#ifndef __DAQBuilderFileOutputStream_HH__
#define __DAQBuilderFileOutputStream_HH__
#include <System/IO/DAQBuilderOutputStream.hh>
#include <System/IO/DAQBuilderFile.hh>
#include <Exception/DAQBuilderIOException.hh>
#include <Exception/DAQBuilderFileNotFoundException.hh>

namespace DAQBuilder
{
  class FileOutputStream : public OutputStream
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
    void                            _finalize();
  public:
    const  DString                  toString() const ;
  protected:
    File                            _file;
    DBool                           _append;
  protected:
    void                            _open();
  public:
    virtual void  flush()
      throw( IOException * );
    virtual void  write( DByte[] , DULong size )
      throw(Exception*);
    virtual void  close()
      throw(IOException*);
  public :
    FileOutputStream( const DString& fileName , DBool _append = false )
        throw(FileNotFoundException * );
    FileOutputStream( const File& _file  ,DBool _append = false )
        throw(FileNotFoundException * );
    FileOutputStream( const FileOutputStream& right )
        throw(FileNotFoundException * );
    ~FileOutputStream();
  public:    
    FileOutputStream& operator   =(const FileOutputStream & right );
  };
  inline void   FileOutputStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("OutputStream");
  }
  inline void   FileOutputStream::_setType()
  {
    this -> _type = "FileOutputStream";
  }
}
#endif
