#ifndef __DAQBuilderFilterInputStream_HH__
#define __DAQBuilderFilterInputStream_HH__
#include <System/IO/DAQBuilderInputStream.hh>
#include <Exception/DAQBuilderIOException.hh>
#include <Util/DAQBuilderSmartPointer.hh>
namespace DAQBuilder
{
  class FilterInputStream : public InputStream
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
    void                            _finalize();
  protected:
    SmartPointer                    _inputStream;
  public:
    const  DString           toString() const =0;
  public:
    virtual DULong  available() const ;                       
    /*
    virtual void  mark()=0;                       
    virtual DBool markSupported()=0;              
    virtual void  read( DByte[] , DULong size )
      throw(Exception*)=0;
    virtual void  reset()                      
      throw(IOException*)=0;
    virtual DLong skip( DLong     nSkip)       
      throw(IOException*)=0;
    virtual void  close()
      throw(IOException*)=0;
*/
  public :
    FilterInputStream( InputStream *  _inputStream );
    FilterInputStream( const FilterInputStream& right );
    ~FilterInputStream();
  public:    
    FilterInputStream& operator   =(const FilterInputStream & right );
  };
  inline void    FilterInputStream::_finalize()
  {
  }
  inline DULong  FilterInputStream::available() const                        
  {
     return ((InputStream*)_inputStream.get()) -> available();
   }
  inline FilterInputStream::FilterInputStream( InputStream * inputStream) 
    :InputStream()
  {
    _inputStream = inputStream;
    _setType();
    _setParentClasses();
  }
  inline FilterInputStream::FilterInputStream( const FilterInputStream& right )
    :InputStream(*((InputStream*)&right)),_inputStream(right._inputStream)
  {
    _setType();
    _setParentClasses();
  }
  inline FilterInputStream::~FilterInputStream()
  {
    _finalize();
  }
  inline FilterInputStream& FilterInputStream::operator=( const FilterInputStream & right )
  {
    *((InputStream*)this) = *((InputStream*)&right);
    _finalize();
    _inputStream          = right._inputStream;
    return *this;
  }
  inline void   FilterInputStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("InputStream");
  }
  inline void   FilterInputStream::_setType()
  {
    this -> _type = "FilterInputStream";
  }
}
#endif
