#ifndef __DAQBuilderFilterOutputStream_HH__
#define __DAQBuilderFilterOutputStream_HH__
#include <System/IO/DAQBuilderOutputStream.hh>
#include <Exception/DAQBuilderIOException.hh>
#include <Util/DAQBuilderSmartPointer.hh>
namespace DAQBuilder
{
  class FilterOutputStream : public OutputStream 
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
    void                            _finalize();
  public:
    const  DString           toString() const =0;
  protected:
    SmartPointer                    _outputStream;
  public:
    virtual void  flush()
      throw(IOException*)=0;
    virtual void  write( DByte[] , DULong size )
      throw(Exception*)=0;
    virtual void  close()
      throw(IOException*)=0;
  public :
    FilterOutputStream( OutputStream * _outputStream);
    FilterOutputStream( const FilterOutputStream& right );
    ~FilterOutputStream();
  public:    
    FilterOutputStream& operator   =(const FilterOutputStream & right );
  };
  inline void FilterOutputStream::_finalize()
    {
    ((OutputStream*)_outputStream.get())->flush();
    }
    inline FilterOutputStream::FilterOutputStream( OutputStream * outputStream) 
      :OutputStream()
    {
      if(outputStream!=NULL)
       _outputStream = outputStream;
      _setType();
      _setParentClasses();
    }
    inline FilterOutputStream::FilterOutputStream( const FilterOutputStream& right )
      :OutputStream(*((OutputStream*)&right)),_outputStream(right._outputStream)
    {
      _setType();
      _setParentClasses();
    }
    inline FilterOutputStream::~FilterOutputStream()
    {
       _finalize();
    }
    inline FilterOutputStream& FilterOutputStream::operator=( const FilterOutputStream & right )
    {
      *((OutputStream*)this) = *((OutputStream*)&right);
      _finalize();
      _outputStream          = right._outputStream;
      return *this;
    }
  inline void   FilterOutputStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("OutputStream");
  }
  inline void   FilterOutputStream::_setType()
  {
    this -> _type = "FilterOutputStream";
  }
}
#endif
