#include <System/IO/DAQBuilderInflaterInputStream.hh>
#include <System/IO/DAQBuilderPrimitiveDataInputStream.hh>
#include <System/DAQBuilderInflater.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
  void                            InflaterInputStream::_finalize()
  {
    _bufferQueue.clear();
  }

  const  DString                  InflaterInputStream::toString() const 
  {
    DString aString ;
    aString += "Available Size : ";
    aString += String::digitToString(available());
    aString += ((Inflater*)_inflater.get())->toString();
    aString += "\n";
    return aString;
  }
  void  InflaterInputStream::_getNextData()
    throw( Exception * )
  {
    PrimitiveDataInputStream aPrimitiveDataInputStream((InputStream*)_inputStream.get());
    DULong aBufferSize    = aPrimitiveDataInputStream.readULong();
    DByte  *  aBuffer     = new DByte[aBufferSize];

    DULong    aCount      = ((InputStream*)_inputStream.get())->read(aBuffer,aBufferSize);
    if(aCount==0)return;
    std::cout<<_inflater.get()<<std::endl;
    ByteArray aInflate    = ((Inflater*)_inflater.get())->unCompress(aBuffer,aCount);
    std::copy(aInflate.begin(),aInflate.end(),std::back_inserter(_bufferQueue));
    delete  []  aBuffer;
  }
  void  InflaterInputStream::mark()
  {
    ((InputStream*)_inputStream.get()) -> mark();
  }                       
  DBool InflaterInputStream::markSupported()
  {
    return ((InputStream*)_inputStream.get()) -> markSupported();
  }              
  DULong  InflaterInputStream::read( DByte * buf , DULong size )
    throw(Exception*)
  {
    DULong i ;
    for( i = 0 ; i < size  ; i ++ )
      {
	if(_bufferQueue.empty())
          _getNextData();

	if(_bufferQueue.empty() ){
          _isEOF =  ((InputStream*)_inputStream.get()) -> isEOF();
          break;
        }

        buf[i]=_bufferQueue.front();
	_bufferQueue.pop_front();
      }
    return i;
  }
  void  InflaterInputStream::reset()                      
    throw(IOException*)
  {
   ((InputStream*)_inputStream.get()) -> reset(); 
    _isEOF =  ((InputStream*)_inputStream.get()) -> isEOF();
  }

  DLong InflaterInputStream::skip( DLong     nSkip)       
    throw(IOException*)
  {
    DLong numSkip = ((InputStream*)_inputStream.get()) -> skip(nSkip);
     _isEOF = ((InputStream*)_inputStream.get()) -> isEOF();
    return numSkip;    
  }

  void  InflaterInputStream::close()
    throw(IOException*)
  {
    ((InputStream*)_inputStream.get()) -> close();
  }
  InflaterInputStream::InflaterInputStream( InputStream * inputStream ,
					    Inflater    * inflater)
    :FilterInputStream(inputStream)
  {
    _inflater = inflater;
    _setType();
    _setParentClasses();
  }
  InflaterInputStream::InflaterInputStream( const InflaterInputStream& right ) 
    :FilterInputStream(*((FilterInputStream*)&right)),_inflater(right._inflater),
     _bufferQueue(right._bufferQueue)
  {
    _setType();
    _setParentClasses();
  }
  InflaterInputStream::~InflaterInputStream()
  {
    _finalize();
  }
  InflaterInputStream& InflaterInputStream::operator   =(const InflaterInputStream & right )
  {
    *((FilterInputStream*)this) =  *((FilterInputStream*)&right);
    _inflater                   =   right._inflater;
    _bufferQueue = right._bufferQueue;
    return *this;
  }
}
