#ifndef __DAQBuilderInflaterInputStream_HH__
#define __DAQBuilderInflaterInputStream_HH__
#include <System/IO/DAQBuilderFilterInputStream.hh>
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class Inflater;
  class InflaterInputStream : public FilterInputStream
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
    void                            _finalize();
  public:
    const  DString                  toString() const ;
  protected:
    SmartPointer                    _inflater;              
    std::list<DByte>                _bufferQueue;
  protected:
    virtual void  _getNextData()
      throw( Exception * );
  public:
//    virtual DULong available() const ;                       
    virtual void  mark();                       
    virtual DBool markSupported();              
    virtual DULong  read( DByte[] , DULong size )
      throw(Exception*);
    virtual void  reset()                      
      throw(IOException*);
    virtual DLong skip( DLong     nSkip)       
      throw(IOException*);
    virtual void  close()
      throw(IOException*);
  public :
    InflaterInputStream( InputStream * _inputStream , 
			  Inflater   * _inflater );
    InflaterInputStream( const InflaterInputStream& right );
    ~InflaterInputStream();
  public:    
    InflaterInputStream& operator   =(const InflaterInputStream & right );
  };
  inline void   InflaterInputStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("InputStream");
    _parentClasses.insert("FilterInputStream");
  }
  inline void   InflaterInputStream::_setType()
  {
    this -> _type = "InflaterInputStream";
  }
}
#endif
