#ifndef __DAQBuilderInputStream_HH__
#define __DAQBuilderInputStream_HH__
#include <DAQBuilderObject.hh>
#include <Exception/DAQBuilderIOException.hh>
namespace DAQBuilder
{
  class InputStream : public Object 
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
    DBool                           _isEOF;
  public:
    const  DString           toString() const =0;
  public:
    virtual DULong available() const =0;
    virtual void  mark()=0;                       
    virtual DBool markSupported()=0;              
    virtual DULong  read( DByte[] , DULong size )
      throw(Exception*)=0;
    virtual void  reset()                      
      throw(IOException*)=0;
    virtual DLong skip( DLong     nSkip)       
      throw(IOException*)=0;
    virtual void  close()
      throw(IOException*)=0;
    /*virtual*/ DBool  isEOF() const;
  public :
    InputStream();
    InputStream( const InputStream& right );
    ~InputStream();
  public:    
    InputStream& operator   =(const InputStream & right );
  };
    inline InputStream::InputStream() 
      :Object(),_isEOF(false)
    {
       _setType();
       _setParentClasses();
    }
    inline InputStream::InputStream( const InputStream& right )
      :Object(*((Object*)&right)),_isEOF(right._isEOF)
    {
       _setType();
       _setParentClasses();
    }
    inline InputStream::~InputStream()
    {
       _finalize();
    }
    inline InputStream& InputStream::operator=( const InputStream & right )
    {
      *((Object*)this) = *((Object*)&right);
      _isEOF           =right._isEOF;
      return *this;
    }
  inline void   InputStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline void   InputStream::_setType()
  {
    this -> _type = "InputStream";
  }
    inline DBool  InputStream::isEOF() const
   {
     return _isEOF;
   }
}
#endif
