#include <System/IO/DAQBuilderInputStreamToOutputStream.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
  void                            InputStreamToOutputStream::_finalize()
  {
    ((OutputStream*)_outputStream.get()) -> flush();
  }
  
  const  DString                  InputStreamToOutputStream::toString() const 
  { 
    DString aString ;//= _toStringHeader(); 
   // aString        += _toStringFooter(); 
    return aString;
  }

 DULong  InputStreamToOutputStream::start() 
    throw(Exception*)
  {
    DULong totalRead = 0;
    DULong numRead = 0;
    try{
    //while(_inputStream->available() != 0 ){
    while(((InputStream*)_inputStream.get())->isEOF()==false){
      DByte * aBuf = new DByte[ _readSize ];
      numRead = ((InputStream*)_inputStream.get()) -> read( aBuf , _readSize );
      ((OutputStream*)_outputStream.get()) -> write( aBuf, numRead );
      totalRead += numRead;
      delete [] aBuf;
    }
    }catch(Exception * e ){
       std::cout<< e <<std::endl;
       delete e;
    }
    return totalRead;
  }
  InputStreamToOutputStream::InputStreamToOutputStream( InputStream  *  inputStream , 
						        OutputStream *  outputStream , 
						        const DULong&   readSize)
    :Object(),
     _readSize(readSize)
  {
      _inputStream  =inputStream;
      _outputStream =outputStream;
      _setType();
      _setParentClasses();
  }
  InputStreamToOutputStream::InputStreamToOutputStream( const InputStreamToOutputStream& right )
    :Object(*((Object*)&right)),
     _inputStream(right._inputStream),
     _outputStream(right._outputStream),
     _readSize(right._readSize)
  {
    _setType();
    _setParentClasses();
  }
  InputStreamToOutputStream::~InputStreamToOutputStream()
  {
    _finalize();
  }
  InputStreamToOutputStream& InputStreamToOutputStream::operator=( const InputStreamToOutputStream& right )
  {
    *((Object*)this) =    *((Object*)&right);
      _inputStream  =right._inputStream;
      _outputStream =right._outputStream;
     _readSize    = right._readSize;
     return *this;
   }
}
