#ifndef __DAQBuilderInputStreamToOutputStreamStream_HH__
#define __DAQBuilderInputStreamToOutputStreamStream_HH__
#include <System/IO/DAQBuilderInputStream.hh>
#include <System/IO/DAQBuilderOutputStream.hh>
#include <Exception/DAQBuilderIOException.hh>
#include <Util/DAQBuilderSmartPointer.hh>

namespace DAQBuilder
{
  class InputStreamToOutputStream : public Object
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
    void                            _finalize();
  public:
    const  DString                  toString() const ;
  protected:
    SmartPointer                    _inputStream;
    SmartPointer                    _outputStream;
    DULong                          _readSize;
  public:
    virtual  DULong start()
      throw(Exception*);
  public :
    InputStreamToOutputStream( InputStream * _inputStream , 
			       OutputStream * _outputStream , 
			       const DULong& _readSize=10240);
    InputStreamToOutputStream( const InputStreamToOutputStream& right );
    ~InputStreamToOutputStream();
  public:    
    InputStreamToOutputStream& operator   =(const InputStreamToOutputStream & right );
  };
  inline void   InputStreamToOutputStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline void   InputStreamToOutputStream::_setType()
  {
    this -> _type = "InputStreamToOutputStream";
  }
}
#endif
