#include <System/IO/DAQBuilderObjectInputStream.hh>
#include <System/DAQBuilderSerializableObjectLoader.hh>
//#include <Primitives/DAQBuilderPrimitivesSerializableObjects.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
  void                            ObjectInputStream::_finalize()
  {;}

  const  DString                  ObjectInputStream::toString() const 
  {
    DString aString;// = _toStringHeader();
    aString += "AvailableSize  : ";
    aString += String::digitToString(available());
    aString += "\n";
    //aString += _toStringFooter();
    return aString;
  }

  void  ObjectInputStream::mark()
  {
    if(markSupported())
      ((InputStream*)_inputStream.get()) -> mark();
  }
/*  DULong ObjectInputStream::available() const 
  {
    return _inputStream -> available();
  }*/
  DBool ObjectInputStream::markSupported()
  {
    return ((InputStream*)_inputStream.get()) -> markSupported();
  }

  SerializableObject* ObjectInputStream::readObject()
      throw(Exception*)
  {
    DString aObjectTypeName  = readString(); 
    DULong  aObjectSize      = readULong();
    DByte  * aBuf            = new DByte[ aObjectSize ];

    read( aBuf , aObjectSize );
    
    SerializableObject * returnObject =
      SerializableObjectLoader::getObject( aObjectTypeName );
    
    returnObject -> unSerialize( aBuf , aObjectSize );

    delete [] aBuf;
    return returnObject;
  }

  void  ObjectInputStream::reset()                      
    throw(IOException*)
  {
    ((InputStream*)_inputStream.get()) -> reset();
  }
  DLong ObjectInputStream::skip( DLong     nSkip)       
    throw(IOException*)
  {
    DLong numSkip =((InputStream*)_inputStream.get()) -> skip(nSkip);
    _isEOF =((InputStream*)_inputStream.get()) -> isEOF();
    return  numSkip;
  }
  void  ObjectInputStream::close()
    throw(IOException*)
  {
    ((InputStream*)_inputStream.get()) -> close();
  }
  ObjectInputStream::ObjectInputStream( InputStream * inputStream )
    :PrimitiveDataInputStream(inputStream)
  {
    _setType();
    _setParentClasses();
  }
  ObjectInputStream::ObjectInputStream( const ObjectInputStream& right ) 
    :PrimitiveDataInputStream(*((PrimitiveDataInputStream*)&right))
  {
    _setType();
    _setParentClasses();
  }
  ObjectInputStream::~ObjectInputStream()
  {
    _finalize();
  }
  ObjectInputStream& ObjectInputStream::operator   =(const ObjectInputStream & right )
  {
    *((PrimitiveDataInputStream*)this) =       *((PrimitiveDataInputStream*)&right);
    return *this;
  }
}
