#ifndef __DAQBuilderObjectInputStream_HH__
#define __DAQBuilderObjectInputStream_HH__
#include <System/IO/DAQBuilderPrimitiveDataInputStream.hh>
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class SerializableObject;
  class ObjectInputStream : public PrimitiveDataInputStream
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
    void                            _finalize();
  public:
    const  DString                  toString() const ;
  protected:
  public:
    virtual void  mark();
//    virtual DULong available() const ;
    virtual DBool markSupported();

    virtual SerializableObject* readObject()
      throw(Exception*);

    virtual void  reset()                      
      throw(IOException*);
    virtual DLong skip( DLong     nSkip)       
      throw(IOException*);
    virtual void  close()
      throw(IOException*);
  public :
    ObjectInputStream( InputStream * _inputStream);
    ObjectInputStream( const ObjectInputStream& right );
    ~ObjectInputStream();
  public:    
    ObjectInputStream& operator   =(const ObjectInputStream & right );
  };
  inline void   ObjectInputStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("InputStream");
    _parentClasses.insert("FilterInputStream");
    _parentClasses.insert("PrimitiveDataInputStream");
  }
  inline void   ObjectInputStream::_setType()
  {
    this -> _type = "ObjectInputStream";
  }
}
#endif
