#include <System/IO/DAQBuilderObjectOutputStream.hh>
#include <DAQBuilderSerializableObject.hh>

namespace DAQBuilder
{
  const  DString                  ObjectOutputStream::toString() const 
  {
    DString aString;// = _toStringHeader();
    //aString += _toStringFooter();
    return aString;
  }

  void ObjectOutputStream::writeObject( SerializableObject& sobj  )
    throw(Exception*)
  {
    writeString( sobj.getType() );
    ByteArray aByteArray = sobj.serialize();
    DULong size          = aByteArray.size();
    writeULong(size);
    if(!aByteArray.empty())
    write(&aByteArray[0],size);
  }

  void ObjectOutputStream::writeObject( SerializableObject* sobj  )
    throw(Exception*)
  {
    writeString( sobj->getType() );
    ByteArray aByteArray = sobj->serialize();
    DULong size          = aByteArray.size();
    writeULong(size);

    if(!aByteArray.empty())
    write(&aByteArray[0],size);
  }
  
  void  ObjectOutputStream::close()
    throw(IOException*)
  {
    ((OutputStream*)_outputStream.get()) -> close();
  }
  ObjectOutputStream::ObjectOutputStream( OutputStream * inputStream )
    :PrimitiveDataOutputStream(inputStream)
  {
    _setType();
    _setParentClasses();
  }
  ObjectOutputStream::ObjectOutputStream( const ObjectOutputStream& right ) 
    :PrimitiveDataOutputStream(*((PrimitiveDataOutputStream*)&right))
  {
    _setType();
    _setParentClasses();
  }
  ObjectOutputStream::~ObjectOutputStream()
  {
    //_finalize();
  }
  ObjectOutputStream& ObjectOutputStream::operator   =(const ObjectOutputStream & right )
  {
    *((PrimitiveDataOutputStream*)this) =       *((PrimitiveDataOutputStream*)&right);
    return *this;
  }
}
