#ifndef __DAQBuilderObjectOutputStream_HH__
#define __DAQBuilderObjectOutputStream_HH__
#include <System/IO/DAQBuilderPrimitiveDataOutputStream.hh>
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class SerializableObject;
  class ObjectOutputStream : public PrimitiveDataOutputStream
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
//    void                            _finalize();
  public:
    const  DString                  toString() const ;
  protected:
  public:

    virtual void writeObject( SerializableObject& sobj  )
      throw(Exception*);
    virtual void writeObject( SerializableObject* sobj  )
      throw(Exception*);

    virtual void  close()
      throw(IOException*);
  public :
    ObjectOutputStream( OutputStream * _outputStream);
    ObjectOutputStream( const ObjectOutputStream& right );
    ~ObjectOutputStream();
  public:    
    ObjectOutputStream& operator   =(const ObjectOutputStream & right );
  };
  inline void   ObjectOutputStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("OutputStream");
    _parentClasses.insert("FilterOutputStream");
    _parentClasses.insert("PrimitiveDataOutputStream");
  }
  inline void   ObjectOutputStream::_setType()
  {
    this -> _type = "ObjectOutputStream";
  }
}
#endif
