#ifndef __DAQBuilderOutputStream_HH__
#define __DAQBuilderOutputStream_HH__
#include <DAQBuilderObject.hh>
#include <Exception/DAQBuilderIOException.hh>
namespace DAQBuilder
{
  class OutputStream : public Object 
  {
  private:
    void                            _setType();
    void                            _setParentClasses();
  public:
    const  DString           toString() const =0;
  public:
    virtual void  flush()
      throw(IOException*)=0;
    virtual void  write( DByte[] , DULong size )
      throw(Exception*)=0;
    virtual void  close()
      throw(IOException*)=0;
  public :
    OutputStream();
    OutputStream( const OutputStream& right );
    ~OutputStream();
  public:    
    OutputStream& operator   =(const OutputStream & right );
  };
    inline OutputStream::OutputStream() 
      :Object()
    {
       _setType();
       _setParentClasses();
    }
    inline OutputStream::OutputStream( const OutputStream& right )
      :Object(*((Object*)&right))
    {
       _setType();
       _setParentClasses();
    }
    inline OutputStream::~OutputStream()
    {
       _finalize();
    }
    inline OutputStream& OutputStream::operator=( const OutputStream & right )
    {
      *((Object*)this) = *((Object*)&right);
      return *this;
    }
  inline void   OutputStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline void   OutputStream::_setType()
  {
    this -> _type = "OutputStream";
  }
}
#endif
