#include <System/IO/DAQBuilderPrimitiveDataInputStream.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
  void                            PrimitiveDataInputStream::_finalize()
  {;}

  const  DString                  PrimitiveDataInputStream::toString() const 
  {
    DString aString;// = _toStringHeader();
    aString += "AvailableSize  : ";
    aString += String::digitToString(available());
    aString += "\n";
    //aString += _toStringFooter();
    return aString;
  }

  void  PrimitiveDataInputStream::mark()
  {
    if(markSupported())
      ((InputStream*)_inputStream.get()) -> mark();
  }
/*  DULong PrimitiveDataInputStream::available() const 
  {
    return _inputStream -> available();
  }*/
  DBool PrimitiveDataInputStream::markSupported()
  {
    return ((InputStream*)_inputStream.get()) -> markSupported();
  }

  DULong  PrimitiveDataInputStream::read( DByte* buffer , DULong size )
    throw(Exception*)
  {
    DULong numRead = ((InputStream*)_inputStream.get()) -> read(buffer,size);
      _isEOF =((InputStream*)_inputStream.get()) -> isEOF() ;
    return numRead;
  }
  DChar PrimitiveDataInputStream::readChar()
    throw(Exception*)
  {
    return (DChar)readByte();
  }
  DBool  PrimitiveDataInputStream::readBool()
    throw(Exception*)
  {
    DShort length = sizeof(DBool);
    DByte  *b= new DByte[length] ; 
    ::bzero(b,length);
    read(b,length);
    DShort i;
    DBool  aReturn;
    ::bzero(&aReturn,sizeof(aReturn));
    for( i = 0 ; i < length ; i++)
      aReturn |= (DBool)((b[i])<<(8*i)   );
    delete [] b;
    return aReturn;
  }
  DByte  PrimitiveDataInputStream::readByte()
    throw(Exception*)
  {
   DByte  b ; 
   ::bzero(&b,sizeof(b));
    read(&b,1);
    return b;
  }
  DInt  PrimitiveDataInputStream::readInt()
    throw(Exception*)
  {
    DShort length = sizeof(DInt);
    DByte  *b= new DByte[length] ; 
   ::bzero(b,length);
    read(b,length);
    DShort i;
    DInt  aReturn;
   
    ::bzero(&aReturn,sizeof(aReturn));
    for( i = 0 ; i < length ; i++)
      aReturn |= (DInt)((b[i])<<(8*i)  );
    delete [] b;
    return aReturn;
  }
  DUInt  PrimitiveDataInputStream::readUInt()
    throw(Exception*)
  {
    DShort length = sizeof(DUInt);
    DByte  *b= new DByte[length] ; 
   ::bzero(b,length);
    read(b,length);
    DShort i;
    DUInt  aReturn;
    ::bzero(&aReturn,sizeof(aReturn));
    for( i = 0 ; i < length ; i++)
      aReturn |= (DInt)((b[i])<<(8*i)   );
    delete [] b;
    return aReturn;
  }
  DLong  PrimitiveDataInputStream::readLong()
    throw(Exception*)
  {
    DShort length = sizeof(DLong);
    DByte  *b = new DByte[length] ; 
   ::bzero(b,length);
    read(b,length);
    DShort i;
    DLong  aReturn;
    ::bzero(&aReturn,sizeof(aReturn));
    for(i = 0 ; i < length ; i++)
      aReturn |= (DLong)((b[i])<<(8*i)   );
    delete [] b;
    return aReturn;
  }
  DULong  PrimitiveDataInputStream::readULong()
    throw(Exception*)
  {
    DShort length = sizeof(DULong);
    DByte  *b = new DByte[length] ; 
   ::bzero(b,length);
    read(b,length);
    DShort i;
    DULong  aReturn;
    ::bzero(&aReturn,sizeof(aReturn));
    for(i = 0 ; i < length ; i++)
      aReturn |= (DLong)((b[i])<<(8*i)   );
    delete [] b;
    return aReturn;
  }
  DShort  PrimitiveDataInputStream::readShort()
    throw(Exception*)
  {
    DShort length = sizeof(DShort);
    DByte  *b= new DByte[length] ; 
   ::bzero(b,length);
    read(b,length);
    DShort i;
    DShort aReturn;
    ::bzero(&aReturn,sizeof(aReturn));
    for(i = 0 ; i < length ; i++)
      aReturn |= (DShort)((b[i])<<(8*i)   );
    delete [] b;
    return aReturn;
  }
  DUShort  PrimitiveDataInputStream::readUShort()
    throw(Exception*)
  {
    DShort length = sizeof(DUShort);
    DByte  *b= new DByte[length] ; 
   ::bzero(b,length);
    read(b,length);
    DShort i;
    DUShort aReturn;
    ::bzero(&aReturn,sizeof(aReturn));
    for(i = 0 ; i < length ; i++)
      aReturn |= (DShort)((b[i])<<(8*i)   );
    delete [] b;
    return aReturn;
  }
   DDouble PrimitiveDataInputStream::readDouble()
      throw(Exception*)
   {
      const DChar * aDouble = readString().c_str();
      return (DDouble)atof(aDouble);
   }
    DFloat PrimitiveDataInputStream::readFloat()
     throw(Exception*)
   {
      const DChar * aFloat = readString().c_str();
      return (DDouble)atof(aFloat);
   }
  DString PrimitiveDataInputStream::readString()
    throw(Exception*)
  {
    DInt length = readInt();
    //std::cout<<"StringLength : "<< length << std::endl;
    DInt i;
    DString aReturn;
    for(i = 0 ; i < length ; i++)
      aReturn.append(1,readChar());
    return aReturn;
  }

  void  PrimitiveDataInputStream::reset()                      
    throw(IOException*)
  {
    ((InputStream*)_inputStream.get()) -> reset();
  }
  DLong PrimitiveDataInputStream::skip( DLong     nSkip)       
    throw(IOException*)
  {
    DLong numSkip =((InputStream*)_inputStream.get()) -> skip(nSkip);
    _isEOF =((InputStream*)_inputStream.get()) -> isEOF();
    return  numSkip;
  }
  void  PrimitiveDataInputStream::close()
    throw(IOException*)
  {
    ((InputStream*)_inputStream.get()) -> close();
  }
  PrimitiveDataInputStream::PrimitiveDataInputStream( InputStream * inputStream )
    :FilterInputStream(inputStream)
  {
    _setType();
    _setParentClasses();
  }
  PrimitiveDataInputStream::PrimitiveDataInputStream( const PrimitiveDataInputStream& right ) 
    :FilterInputStream(*((FilterInputStream*)&right))
  {
    _setType();
    _setParentClasses();
  }
  PrimitiveDataInputStream::~PrimitiveDataInputStream()
  {
    _finalize();
  }
  PrimitiveDataInputStream& PrimitiveDataInputStream::operator   =(const PrimitiveDataInputStream & right )
  {
    *((FilterInputStream*)this) =       *((FilterInputStream*)&right);
    return *this;
  }
}
