#ifndef __DAQBuilderPrimitiveDataInputStream_HH__
#define __DAQBuilderPrimitiveDataInputStream_HH__
#include <System/IO/DAQBuilderFilterInputStream.hh>
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class PrimitiveDataInputStream : public FilterInputStream
  {
  protected:
     virtual void                            _setType();
     virtual void                            _setParentClasses();
     virtual void                            _finalize();
  public:
     virtual const  DString                  toString() const ;
  protected:
  public:
     virtual void  mark();
//     DULong available() const ;
     virtual DBool markSupported();

     DULong  read( DByte[] , DULong size )
      throw(Exception*);
     DChar  readChar()
      throw(Exception*);
     DBool  readBool()
      throw(Exception*);
     DByte  readByte()
      throw(Exception*);
     DInt  readInt()
      throw(Exception*);
     DUInt  readUInt()
      throw(Exception*);
     DLong  readLong()
      throw(Exception*);
     DULong  readULong()
      throw(Exception*);
     DShort readShort()
      throw(Exception*);
     DUShort readUShort()
      throw(Exception*);
     DDouble readDouble()
      throw(Exception*);
     DFloat readFloat()
      throw(Exception*);
     DString readString()
      throw(Exception*);

     virtual void  reset()                      
      throw(IOException*);
     virtual DLong skip( DLong     nSkip)       
      throw(IOException*);
     virtual void  close()
      throw(IOException*);
  public :
    PrimitiveDataInputStream( InputStream * _inputStream);
    PrimitiveDataInputStream( const PrimitiveDataInputStream& right );
     virtual  ~PrimitiveDataInputStream();
  public:    
    PrimitiveDataInputStream& operator   =(const PrimitiveDataInputStream & right );
  };
  inline void   PrimitiveDataInputStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("InputStream");
    _parentClasses.insert("FilterInputStream");
  }
  inline void   PrimitiveDataInputStream::_setType()
  {
    this -> _type = "PrimitiveDataInputStream";
  }
}
#endif
