#include <System/IO/DAQBuilderPrimitiveDataOutputStream.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
/*  void                            PrimitiveDataOutputStream::_finalize()
  {;}

*/
  const  DString                  PrimitiveDataOutputStream::toString() const 
  {
    DString aString;// = _toStringHeader();
    //aString += _toStringFooter();
    return aString;
  }

  void  PrimitiveDataOutputStream::write( DByte* buffer , DULong size )
    throw(Exception*)
  {
    ((OutputStream*)(_outputStream.get())) -> write(buffer,size);
  }
  void PrimitiveDataOutputStream::writeChar( const DChar &  c )
    throw(Exception*)
  {
    return writeByte((DByte)c);
  }
  void  PrimitiveDataOutputStream::writeBool( const DBool& c )
    throw(Exception*)
  {
    DShort length = sizeof(DBool);
    DShort i;
    DByte*  b = new DByte[length];
    for( i = 0 ; i < length ; i ++ )
      b[i] =( c >> (8*i) ) & 0x00ff;
    write(b,length);
    delete [] b;
  }
  void  PrimitiveDataOutputStream::flush()
    throw(IOException*)
  { 
    ((OutputStream*)_outputStream.get()) -> flush();
  }
  void  PrimitiveDataOutputStream::writeByte(const DByte& c )
    throw(Exception*)
  {
    DByte b = c;
    write(&b,(DULong)1);
  }
  void  PrimitiveDataOutputStream::writeInt( const DInt& c)
    throw(Exception*)
  {
    DShort length = sizeof(DInt);
    DShort i;
    DByte*  b = new DByte[length];
    for( i = 0 ; i < length ; i ++ )
      b[i] =( c >> (8*i) ) & 0x00ff;
    write(b,length);
    delete [] b;
  }
  void  PrimitiveDataOutputStream::writeUInt( const DUInt& c)
    throw(Exception*)
  {
    DShort length = sizeof(DUInt);
    DShort i;
    DByte*  b = new DByte[length];
    for( i = 0 ; i < length ; i ++ )
      b[i] =( c >> (8*i) ) & 0x00ff;
    write(b,length);
    delete [] b;
  }
  void  PrimitiveDataOutputStream::writeLong(const DLong& c)
    throw(Exception*)
  {
    DShort length = sizeof(DLong);
    DShort i;
    DByte*  b = new DByte[length];
    for( i = 0 ; i < length ; i ++ )
      b[i] =( c >> (8*i) ) & 0x00ff;
    write(b,length);
    delete [] b;
  }
  void  PrimitiveDataOutputStream::writeULong(const DULong& c)
    throw(Exception*)
  {
    DShort length = sizeof(DULong);
    DShort i;
    DByte*  b = new DByte[length];
    for( i = 0 ; i < length ; i ++ )
      b[i] =( c >> (8*i) ) & 0x00ff;
    write(b,length);
    delete [] b;
  }
  void  PrimitiveDataOutputStream::writeShort(const DShort& c )
    throw(Exception*)
  {
    DShort length = sizeof(DShort);
    DShort i;
    DByte*  b = new DByte[length];
    for( i = 0 ; i < length ; i ++ )
      b[i] =( c >> (8*i) ) & 0x00ff;
    write(b,length);
    delete [] b;
  }
  void  PrimitiveDataOutputStream::writeUShort(const DUShort& c )
    throw(Exception*)
  {
    DShort length = sizeof(DUShort);
    DShort i;
    DByte*  b = new DByte[length];
    for( i = 0 ; i < length ; i ++ )
      b[i] =( c >> (8*i) ) & 0x00ff;
    write(b,length);
    delete [] b;
  }
  void PrimitiveDataOutputStream::writeDouble( const DDouble & s )
    throw(Exception*)
  {
    writeString(String::digitToString((DDouble)s));
  }
  void PrimitiveDataOutputStream::writeFloat( const DFloat & s )
    throw(Exception*)
  {
    writeString(String::digitToString((DDouble)s));
  }
  void PrimitiveDataOutputStream::writeString( const DString& str)
    throw(Exception*)
  {
    DInt size = (DInt)str.size();
    writeInt(size);
    DByte * aBuf = new DByte[str.size()];
    std::copy(str.begin(),str.end(),aBuf);
    write(aBuf,str.size());
    delete [] aBuf;
  }

  void  PrimitiveDataOutputStream::close()
    throw(IOException*)
  {
    ((OutputStream*)_outputStream.get()) -> close();
  }
  PrimitiveDataOutputStream::PrimitiveDataOutputStream( OutputStream * inputStream )
    :FilterOutputStream(inputStream)
  {
    _setType();
    _setParentClasses();
  }
  PrimitiveDataOutputStream::PrimitiveDataOutputStream( const PrimitiveDataOutputStream& right ) 
    :FilterOutputStream(*((FilterOutputStream*)&right))
  {
    _setType();
    _setParentClasses();
  }
  PrimitiveDataOutputStream::~PrimitiveDataOutputStream()
  {
    //_finalize();
  }
  PrimitiveDataOutputStream& PrimitiveDataOutputStream::operator   =(const PrimitiveDataOutputStream & right )
  {
    *((FilterOutputStream*)this) =       *((FilterOutputStream*)&right);
    return *this;
  }
}
