#ifndef __DAQBuilderPrimitiveDataOutputStream_HH__
#define __DAQBuilderPrimitiveDataOutputStream_HH__
#include <System/IO/DAQBuilderFilterOutputStream.hh>
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class PrimitiveDataOutputStream : public FilterOutputStream
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
//    void                            _finalize();
  public:
    const  DString                  toString() const ;
  protected:
  public:
     void  flush()
      throw(IOException*);

     void  write( DByte[] , DULong size )
      throw(Exception*);
     void  writeChar( const DChar & c)
      throw(Exception*);
     void  writeBool( const DBool & b )
      throw(Exception*);
     void  writeByte( const DByte & b )
      throw(Exception*);
     void  writeInt( const DInt & i )
      throw(Exception*);
     void  writeUInt( const DUInt & i )
      throw(Exception*);
     void  writeLong( const DLong & l)
      throw(Exception*);
     void  writeULong( const DULong & l)
      throw(Exception*);
     void writeShort( const DShort & s )
      throw(Exception*);
     void writeUShort( const DUShort & s )
      throw(Exception*);
     void writeDouble( const DDouble & s )
      throw(Exception*);
     void writeFloat( const DFloat & s )
      throw(Exception*);
     void writeString( const DString & str )
      throw(Exception*);

     virtual void  close()
      throw(IOException*);
  public :
    PrimitiveDataOutputStream( OutputStream * _outputStream);
    PrimitiveDataOutputStream( const PrimitiveDataOutputStream& right );
    virtual ~PrimitiveDataOutputStream();
  public:    
    PrimitiveDataOutputStream& operator   =(const PrimitiveDataOutputStream & right );
  };
  inline void   PrimitiveDataOutputStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("OutputStream");
    _parentClasses.insert("FilterOutputStream");
  }
  inline void   PrimitiveDataOutputStream::_setType()
  {
    this -> _type = "PrimitiveDataOutputStream";
  }
}
#endif
