#include <System/IO/DAQBuilderPrintStream.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
/*  void                            PrintStream::_finalize()
  {;}

*/
  const  DString                  PrintStream::toString() const 
  {
    DString aString;
    if(!_outputStream.isNull() )
      aString += _outputStream -> toString();
    return aString;
  }
  void  PrintStream::flush()
    throw(IOException*)
  { 
    ((OutputStream*)_outputStream.get()) -> flush();
  }

  void  PrintStream::write( DByte* buffer , DULong size )
    throw(Exception*)
  {
    ((OutputStream*)_outputStream.get()) -> write(buffer,size);
  }
  void PrintStream::print( const DChar &  c )
    throw(Exception*)
  {
    DString str(&c);
    return print(str);
  }
  void  PrintStream::print( const DBool& c )
    throw(Exception*)
  {
    DString str;
    c ? str = "true" : str="false";
    return print(str);
  }
  void  PrintStream::print(const DByte& c )
    throw(Exception*)
  {
    DChar * aBuf = new DChar[5];
    snprintf(aBuf,5,"0x%x",c);
    DString str(aBuf);
    delete [] aBuf;
    return print(str);
   
  }
  void  PrintStream::print( const DInt& c)
    throw(Exception*)
  {
    return print(String::digitToString((DLong)c));
  }
  void  PrintStream::print( const DUInt& c)
    throw(Exception*)
  {
    return print(String::digitToString((DULong)c));
  }
  void  PrintStream::print(const DLong& c)
    throw(Exception*)
  {
    return print(String::digitToString((DLong)c));
  }
  void  PrintStream::print(const DULong& c)
    throw(Exception*)
  {
    return print(String::digitToString((DULong)c));
  }
  void  PrintStream::print(const DShort& c )
    throw(Exception*)
  {
    return print(String::digitToString((DLong)c));
  }
  void  PrintStream::print(const DUShort& c )
    throw(Exception*)
  {
    return print(String::digitToString((DULong)c));
  }
   void  PrintStream::print( const DDouble & c )
      throw(Exception*)
  {
    return print(String::digitToString((DDouble)c));
  }
     void  PrintStream::print( const DFloat & c )
      throw(Exception*)
  {
    return print(String::digitToString((DDouble)c));
  }
  void PrintStream::print( const DString& arg)
    throw(Exception*)
  {
   DULong aPrintablePoint;
   DString str = arg;
    for( aPrintablePoint= 0 ; aPrintablePoint < str.size() ; aPrintablePoint ++)
      {  
        if(!isprint(str[aPrintablePoint]) && str[aPrintablePoint] != '\n') 
	  break;
      }
    if(!str.empty())
      write(((DByte*)&str[0]),aPrintablePoint);
    flush();
  }
  void PrintStream::print( const DChar * str)
    throw(Exception*)
  {
    DString aStr(str);
    return print(aStr);
  }
  void PrintStream::print( const Object& object )
    throw(Exception*)
  {
    DString aStr = object._toStringHeader();
    aStr        += object.toString();
    aStr        += object._toStringFooter();
    return print(aStr);
  }
  void  PrintStream::print( const Object* obj )
       throw(Exception*)
  {
    if(obj != NULL )
     print(*obj);
  }

  void PrintStream::println( const DChar &  c )
    throw(Exception*)
  {
    DString str(&c);
    return println(str);
  }
  void  PrintStream::println( const DBool& c )
    throw(Exception*)
  {
    DString str;
    c ? str = "true" : str="false";
    //str+="\n";
    return println(str);
  }
  void  PrintStream::println(const DByte& c )
    throw(Exception*)
  {
    DChar * aBuf = new DChar[5];
    snprintf(aBuf,5,"0x%x",c);
    DString str(aBuf);
    delete [] aBuf;
    return println(str);
     }
  void  PrintStream::println( const DInt& c)
    throw(Exception*)
  {
    return println(String::digitToString((DLong)c));
  }
  void  PrintStream::println( const DUInt& c)
    throw(Exception*)
  {
    return println(String::digitToString((DULong)c));
  }
  void  PrintStream::println(const DLong& c)
    throw(Exception*)
  {
    return println(String::digitToString((DLong)c));
  }
  void  PrintStream::println(const DULong& c)
    throw(Exception*)
  {
    return println(String::digitToString((DULong)c));
  }
  void  PrintStream::println(const DShort& c )
    throw(Exception*)
  {
    return print(String::digitToString((DLong)c));
  }
  void  PrintStream::println(const DUShort& c )
    throw(Exception*)
  {
    return println(String::digitToString((DULong)c));
  }
     void  PrintStream::println( const DDouble & c )
      throw(Exception*)
  {
    return println(String::digitToString((DDouble)c));
  }
     void  PrintStream::println( const DFloat & c )
      throw(Exception*)
  {
    return println(String::digitToString((DDouble)c));
  }
  void PrintStream::println( const DString& str)
    throw(Exception*)
  {
    DString aStr  = str;
    aStr         += "\n";
    print(aStr);
  }
  void PrintStream::println( const DChar * str)
    throw(Exception*)
  {
    DString aStr(str);
    return println(aStr);
  }
  void PrintStream::println( const Object& object )
    throw(Exception*)
  {
    DString aStr = object._toStringHeader();
    aStr        += object.toString();
    aStr        += object._toStringFooter();
    return println(aStr);
  }
  void  PrintStream::println( const Object* obj )
       throw(Exception*)
  {
    if(obj != NULL )
     println(*obj);
  }



  void  PrintStream::close()
    throw(IOException*)
  {
    ((OutputStream*)_outputStream.get()) -> close();
  }
  PrintStream::PrintStream( OutputStream * inputStream )
    :FilterOutputStream(inputStream)
  {
    _setType();
    _setParentClasses();
  }
  PrintStream::PrintStream( const PrintStream& right ) 
    :FilterOutputStream(*((FilterOutputStream*)&right))
  {
    _setType();
    _setParentClasses();
  }
  PrintStream::~PrintStream()
  {
    //_finalize();
  }
  PrintStream& PrintStream::operator   =(const PrintStream & right )
  {
    *((FilterOutputStream*)this) =       *((FilterOutputStream*)&right);
    return *this;
  }
}
