#ifndef __DAQBuilderPrintStream_HH__
#define __DAQBuilderPrintStream_HH__
#include <System/IO/DAQBuilderFilterOutputStream.hh>
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class PrintStream : public FilterOutputStream
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
//    void                            _finalize();
  public:
    const  DString                  toString() const ;
  protected:

  public:
     void  flush()
      throw(IOException*);

     void  write( DByte[] , DULong size )
      throw(Exception*);

    virtual void  print( const DChar & c )
      throw(Exception*);
    virtual void  print( const DBool & b )
      throw(Exception*);
    virtual void  print( const DByte & b )
      throw(Exception*);
    virtual void  print( const DInt & i )
      throw(Exception*);
    virtual void  print( const DUInt & i )
      throw(Exception*);
    virtual void  print( const DLong & l)
      throw(Exception*);
    virtual void  print( const DULong & l)
      throw(Exception*);
    virtual void  print( const DShort & s )
      throw(Exception*);
    virtual void  print( const DUShort & s )
      throw(Exception*);
    virtual void  print( const DDouble & s )
      throw(Exception*);
    virtual void  print( const DFloat & s )
      throw(Exception*);
    virtual void  print( const DString & str )
      throw(Exception*);
    virtual void  print( const DChar * str )
      throw(Exception*);
    virtual void  print( const Object& obj )
      throw(Exception*);
    virtual void  print( const Object* obj )
      throw(Exception*);
    
    virtual void  println( const DChar & c )
      throw(Exception*);
    virtual void  println( const DBool & b )
      throw(Exception*);
    virtual void  println( const DByte & b )
      throw(Exception*);
    virtual void  println( const DInt & i )
      throw(Exception*);
    virtual void  println( const DUInt & i )
      throw(Exception*);
    virtual void  println( const DLong & l)
      throw(Exception*);
    virtual void  println( const DULong & l)
      throw(Exception*);
    virtual void  println( const DShort & s )
      throw(Exception*);
    virtual void  println( const DUShort & s )
      throw(Exception*);
    virtual void  println( const DDouble & s )
      throw(Exception*);
    virtual void  println( const DFloat & s )
      throw(Exception*);
    virtual void  println( const DString & str )
      throw(Exception*);
    virtual void  println( const DChar * str )
      throw(Exception*);
    virtual void  println( const Object& obj )
      throw(Exception*);
    virtual void  println( const Object* obj )
      throw(Exception*);
    
     virtual void  close()
      throw(IOException*);
  public :
    PrintStream( OutputStream * _outputStream =NULL);
    PrintStream( const PrintStream& right );
    virtual ~PrintStream();
  public:    
    PrintStream& operator   =(const PrintStream & right );
  };
  inline void   PrintStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("OutputStream");
    _parentClasses.insert("FilterOutputStream");
  }
  inline void   PrintStream::_setType()
  {
    this -> _type = "PrintStream";
  }
}
#endif
