#include <System/IO/DAQBuilderScanStream.hh>
#include <System/IO/DAQBuilderPrimitiveDataInputStream.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
  DByte   ScanStream::read()
   throw(Exception *)
  {
    DByte  aByte;
    bzero(&aByte,sizeof(aByte));
 //   ((BufferedInputStream*)this)->read(&aByte,1);
    ((InputStream*)_inputStream.get())->read(&aByte,1);
    return aByte;
  }
  DString ScanStream::readLine()
    throw(Exception*)
  {
    DString aStringBuffer;
    DChar aChar ;
    bzero(&aChar,sizeof(aChar));
      do{ 
        DChar aChar = read(); 
        aStringBuffer+=aChar;
      }while(aChar != '\n');
    return aStringBuffer;
  }

  ScanStream::ScanStream( InputStream * inputStream , DULong _bufferSize )
    :BufferedInputStream(inputStream , _bufferSize )
  {
    _setType();
    _setParentClasses();
  }
  ScanStream::ScanStream( const ScanStream& right ) 
    :BufferedInputStream(*((BufferedInputStream*)&right))
  {
  }
  ScanStream::~ScanStream()
  {
    _finalize();
  }
  ScanStream& ScanStream::operator   =(const ScanStream & right )
  {
    *((BufferedInputStream*)this) =       *((BufferedInputStream*)&right);
    return *this;
  }
}
