#ifndef __DAQBuilderScanInputStream_HH__
#define __DAQBuilderScanInputStream_HH__
#include <System/IO/DAQBuilderBufferedInputStream.hh>
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class ScanStream : public BufferedInputStream
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
  public:
    DByte  read()
      throw(Exception*);
    DString readLine()
      throw(Exception*);
  public :
    ScanStream( InputStream * _inputStream = NULL , DULong _bufferSize = 128 );
    ScanStream( const ScanStream& right );
    ~ScanStream();
  public:    
    ScanStream& operator   =(const ScanStream & right );
  };
  inline void   ScanStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("InputStream");
    _parentClasses.insert("FilterInputStream");
    _parentClasses.insert("BufferedInputStream");
  }
  inline void   ScanStream::_setType()
  {
    this -> _type = "ScanStream";
  }
}
#endif
