#ifndef __DAQBuilderSelectionKey_HH__
#define __DAQBuilderSelectionKey_HH__ 
#include <DAQBuilderObject.hh>

namespace DAQBuilder
{
  class SelectionKey : public Object
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
  public:
    const  DString                  toString() const ;
  public:
    enum{SK_ACCEPT = 0 , SK_CONNECT , SK_READ , SK_WRITE , NUMSK};
  protected:
    DInt                            _option;
  protected:
    SelectionKey( const DInt& _option );
  public:
    SelectionKey( const SelectionKey& right );
    ~SelectionKey();
  public:    
    virtual SelectionKey& operator   =(const SelectionKey & right );
    virtual DBool    operator  ==(const SelectionKey & right ) const ;
    virtual DBool    operator  !=(const SelectionKey & right ) const ;
  public:
    virtual DBool    isAcceptable()    const;
    virtual DBool    isConnectable() const;
    virtual DBool    isReadable() const;
    virtual DBool    isWritable() const;
  };
  inline void   SelectionKey::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline void   SelectionKey::_setType()
  {
    this -> _type = "SelectionKey";
  }
}
#endif
