#include <System/IO/DAQBuilderSocketInputStream.hh>
#include <Primitives/DAQBuilderString.hh>
#include <System/DAQBuilderSystem.hh>

namespace DAQBuilder
{
  void                            SocketInputStream::_finalize()
  {
  /*  try{
    close();
    }catch(IOException * e ){
      std::cerr<< e << std::endl;
      deleteObject((Object*)e);
    }
  */
  }
  const  DString                  SocketInputStream::toString() const 
  {
    DString aString;// = _toStringHeader();
  //    aString += _toStringFooter();
    return aString;
  }

  void  SocketInputStream::mark()
  {;}

  DBool SocketInputStream::markSupported()
  {
    return false;
  }

  DULong SocketInputStream::available() const 
  {
    /*DULong aULong = 0; _socket.getLength() -  _currentPosition;
    return aULong;
    */
    return (DULong)_available;
  }
  DULong  SocketInputStream::read( DByte* buffer , DULong size )
    throw(Exception*)
  {
    if(((Socket*)_socket.get())->isClosed())
      ((Socket*)_socket.get())->connect();

    //std::cout<<&_socket<<std::endl;
    DULong   aRemainSize = size;
    FileDescriptor aFD = ((Socket*)_socket.get())->_socketFD;
    /*DBool buf;
    bzero(&buf,sizeof(buf));
    ::read(aFD,(void*)&buf,sizeof(buf));
    _available = buf;
    */
    while( aRemainSize > 0 )
      {
	ssize_t aTmpReadSize = ::read( aFD , (void*)buffer, aRemainSize );
        //std::cout<<"readsize="<<aTmpReadSize<<std::endl;
        if( aTmpReadSize < 0 )
	  {
            if( errno != EINTR)
	      {
		IOException * e = new IOException(strerror(errno));
		DString aLocation ="SocketInputStream::read(DByte[],DULong)";
		aLocation        += __LINE__;
		e -> insert("Location",aLocation);
		throw e;
	      }
            aTmpReadSize=0;
	  }
        else if(aTmpReadSize == 0){
            _isEOF = true;
            break;
        }
	aRemainSize -= aTmpReadSize;
      }
    return size - aRemainSize; 
  }
  void  SocketInputStream::reset()                      
    throw(IOException*)
  {;}

  DLong SocketInputStream::skip( DLong     nSkip)       
    throw(IOException*)
  {
    if(((Socket*)_socket.get())->isClosed())
      ((Socket*)_socket.get())->connect();
  
    DByte * buf = new DByte[(DULong)nSkip];
    DULong numRead = read(buf,(DULong)nSkip);
    delete [] buf;
    return (DLong)(nSkip - numRead);
  }
  void  SocketInputStream::close()
    throw(IOException*)
  {
      ((Socket*)_socket.get())->close();
  }
  SocketInputStream::SocketInputStream( const DString& hostName , const DInt & port  )
      throw(IOException*)
    :InputStream(),_socket( new Socket(hostName, port  )),_available(true)
  {
    _setType();
    _setParentClasses();
  }
  SocketInputStream::SocketInputStream( const Socket& socket )
      throw(IOException*)
    :InputStream(),_available(true)//
  {
    _socket   = (Object&)socket;
    _setType();
    _setParentClasses();
  }
  SocketInputStream::SocketInputStream( const SocketInputStream& right ) 
      throw(IOException*)
    :InputStream(*((InputStream*)&right)),_socket(right._socket),_available(right._available)
  {
  }
  SocketInputStream::~SocketInputStream()
  {
    _finalize();
  }
  SocketInputStream& SocketInputStream::operator   =(const SocketInputStream & right )
  {
    *((InputStream*)this) =       *((InputStream*)&right);
    _socket               = right._socket;
    _available            = right._available;
    return *this;
  }
}
