#ifndef __DAQBuilderSocketInputStream_HH__
#define __DAQBuilderSocketInputStream_HH__
#include <System/IO/DAQBuilderInputStream.hh>
#include <System/Network/DAQBuilderSocket.hh>
#include <Exception/DAQBuilderIOException.hh>
#include <Util/DAQBuilderSmartPointer.hh>

namespace DAQBuilder
{
  class SocketInputStream : public InputStream
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
    void                            _finalize();
  public:
    const  DString                  toString() const ;
  protected:
    SmartPointer                    _socket;
    DBool                           _available;
   // Socket                          _socket;
  public:
    virtual DULong available() const ;
    virtual void  mark();
    virtual DBool markSupported();
    virtual DULong  read( DByte[] , DULong size )
      throw(Exception*);
    virtual void  reset()                      
      throw(IOException*);
    virtual DLong skip( DLong     nSkip)       
      throw(IOException*);
    virtual void  close()
      throw(IOException*);
  public :
    SocketInputStream( const DString& hostName , const DInt& port )
      throw(IOException*);
    SocketInputStream( const Socket& socket  )
      throw(IOException*);
    SocketInputStream( const SocketInputStream& right )
      throw(IOException*);
    ~SocketInputStream();
  public:    
    SocketInputStream& operator   =(const SocketInputStream & right );
  };
  inline void   SocketInputStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("InputStream");
  }
  inline void   SocketInputStream::_setType()
  {
    this -> _type = "SocketInputStream";
  }
}
#endif
