#include <System/IO/DAQBuilderSocketOutputStream.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
  void                            SocketOutputStream::_finalize()
  {
/*    try{
    close();
    }catch(IOException * e ){
      std::cerr<< e << std::endl;
      deleteObject((Object*)e);
    }
*/
  }

  const  DString                  SocketOutputStream::toString() const 
  {
    DString aString = _toStringHeader();
    aString += _toStringFooter();
    return aString;
  }
  void  SocketOutputStream::flush()
    throw(IOException * )
  {
    ((Socket*)_socket.get())->shutdownWrite();
  }
  
  void  SocketOutputStream::write( DByte* buffer , DULong size )
    throw(Exception*)
  {
    if(((Socket*)_socket.get())->isClosed())
      ((Socket*)_socket.get())->connect();

    //std::cout<<&_socket<<std::endl;

    DULong   aRemainSize = size;
    FileDescriptor aFD = ((Socket*)_socket.get())->_socketFD;
    while( aRemainSize > 0 )
      {
        //std::cout<<"	ssize_t aTmpWriteSize = ::write( _socket._socketFD , (void*)buffer, aRemainSize );";
       /* DBool tmp = true;
        ::write(aFD,(void*)&tmp,sizeof(DBool)); 
        */
        //std::cout<<"write.."<<std::flush;
	ssize_t aTmpWriteSize = ::write( aFD , (void*)buffer, aRemainSize );
        //std::cout<<"writeSize = "<<aTmpWriteSize<<std::endl;
        //std::cout<<"....[OK]\n";
        if( aTmpWriteSize < 0 )
	  {
            if( errno != EINTR)
	      {
		IOException * e = new IOException(strerror(errno));
		DString aLocation ="SocketOutputStream::write(DByte[],DULong)";
		aLocation        += __LINE__;
		e -> insert("Location",aLocation);
		throw e;
	      }
            aTmpWriteSize=0;
	  }
        else if(aTmpWriteSize == 0){
        //std::cout<<"break\n"<<std::flush;
            break;
       }
	aRemainSize -= aTmpWriteSize;
        //std::cout<<"..[OK]\n"<<std::flush;
      }
  }
  void  SocketOutputStream::close()
    throw(IOException*)
  {
    ((Socket*)_socket.get())->close();
  }
  SocketOutputStream::SocketOutputStream( const DString& hostName , const DInt & port  )
        throw(IOException * )
    :OutputStream(),_socket( new Socket(hostName , port ))
  {
    _setType();
    _setParentClasses();
  }
  SocketOutputStream::SocketOutputStream( const Socket& socket )
        throw(IOException * )
    :OutputStream()//,_socket((Object&)socket)
  {
    _socket = (Object&)socket;
    _setType();
    _setParentClasses();
  }
  SocketOutputStream::SocketOutputStream( const SocketOutputStream& right )
        throw(IOException * )
    :OutputStream(*((OutputStream*)&right)),_socket(right._socket)
  {
  }
  SocketOutputStream::~SocketOutputStream()
  {
    _finalize();
  }
  SocketOutputStream& SocketOutputStream::operator   =(const SocketOutputStream & right )
  {
    *((OutputStream*)this) =       *((OutputStream*)&right);
    _socket  = right._socket;
    return *this;
  }
}
