#ifndef __DAQBuilderSocketOutputStream_HH__
#define __DAQBuilderSocketOutputStream_HH__
#include <System/IO/DAQBuilderOutputStream.hh>
#include <System/Network/DAQBuilderSocket.hh>
#include <Exception/DAQBuilderIOException.hh>
#include <Util/DAQBuilderSmartPointer.hh>

namespace DAQBuilder
{
  class SocketOutputStream : public OutputStream
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
    void                            _finalize();
  public:
    const  DString                  toString() const ;
  protected:
    SmartPointer                    _socket;
    //Socket                          _socket;
  protected:
    void                            _open();
  public:
    virtual void  flush()
      throw( IOException * );
    virtual void  write( DByte[] , DULong size )
      throw(Exception*);
    virtual void  close()
      throw(IOException*);
  public :
    SocketOutputStream( const DString& fileName , const DInt & port )
        throw(IOException * );
    SocketOutputStream( const Socket& _socket  )
        throw(IOException * );
    SocketOutputStream( const SocketOutputStream& right )
        throw(IOException * );
    ~SocketOutputStream();
  public:    
    SocketOutputStream& operator   =(const SocketOutputStream & right );
  };
  inline void   SocketOutputStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("OutputStream");
  }
  inline void   SocketOutputStream::_setType()
  {
    this -> _type = "SocketOutputStream";
  }
}
#endif
