#ifndef __DAQBuilderStandardError_HH__
#define __DAQBuilderStandardError_HH__
#include <System/IO/DAQBuilderPrintStream.hh>
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class StandardError : public PrintStream
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
  public :
    StandardError(); 
    StandardError( const StandardError& right );
    virtual ~StandardError();
  public:    
    StandardError& operator   =(const StandardError & right );
  };

  inline void   StandardError::_setType()
  {
    this -> _type = "StandardError";
  }

  inline void   StandardError::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("OutputStream");
    _parentClasses.insert("FilterOutputStream");
    _parentClasses.insert("PrintStream");
  }
}
#endif
