#include <System/IO/DAQBuilderStandardInput.hh>
#include <System/IO/DAQBuilderFile.hh>
#include <System/IO/DAQBuilderFileInputStream.hh>
#include <System/IO/DAQBuilderBufferedInputStream.hh>
namespace DAQBuilder
{
   StandardInput::StandardInput( const StandardInput& right ) 
    :ScanStream(*((ScanStream*)&right))
  {
  }
   StandardInput::~StandardInput()
  {
    _finalize();
  }
   StandardInput& StandardInput::operator   =(const StandardInput & right )
  {
    *((ScanStream*)this) =       *((ScanStream*)&right);
    return *this;
  }
  StandardInput::StandardInput()
    :ScanStream()
  {
    try{
    _setType();
    _setParentClasses();
    File  aStdIn("");
    aStdIn._fileName="StandardInput";
    aStdIn._fd      =1;
    aStdIn._setCancopy();
    _inputStream = new FileInputStream(aStdIn);
    }catch(Exception* e){
      std::cout<< e << std::endl;
      delete e;
    }
  }
}
