#ifndef __DAQBuilderStandardInput_HH__
#define __DAQBuilderStandardInput_HH__
#include <System/IO/DAQBuilderScanStream.hh>
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class StandardInput : public ScanStream
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
  public :
    StandardInput(); 
    StandardInput( const StandardInput& right );
    virtual ~StandardInput();
  public:    
    StandardInput& operator   =(const StandardInput & right );
  };

  inline void   StandardInput::_setType()
  {
    this -> _type = "StandardInput";
  }

  inline void   StandardInput::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("InputStream");
    _parentClasses.insert("FilterInputStream");
    _parentClasses.insert("ScanStream");
  }
}
#endif
