#ifndef __DAQBuilderStandardOutput_HH__
#define __DAQBuilderStandardOutput_HH__
#include <System/IO/DAQBuilderPrintStream.hh>
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class StandardOutput : public PrintStream
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
  public :
    StandardOutput(); 
    StandardOutput( const StandardOutput& right );
    virtual ~StandardOutput();
  public:    
    StandardOutput& operator   =(const StandardOutput & right );
  };

  inline void   StandardOutput::_setType()
  {
    this -> _type = "StandardOutput";
  }

  inline void   StandardOutput::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("OutputStream");
    _parentClasses.insert("FilterOutputStream");
    _parentClasses.insert("PrintStream");
  }
}
#endif
