#include <System/Network/DAQBuilderMultiClientServer.hh>
#include <System/Network/DAQBuilderServerSocket.hh>

namespace DAQBuilder
{
    const  DString           MultiClientServer::toString() const 
    {
	DString aString = _server.isNull() ? "" : _server.toString();
	return aString;
    }
    MultiClientServer::MultiClientServer( const DInt& localPort )
    {
	_setType();
	_setParentClasses();
	_server = new ServerSocket(localPort); 
    }
    MultiClientServer::MultiClientServer( const MultiClientServer& right )
	:Thread(*((Thread*)&right)),_server(right._server)
    {
    }
    MultiClientServer::~MultiClientServer()
    {
    }
    MultiClientServer& MultiClientServer::operator   =(const MultiClientServer & right )
    {
	*((Thread*)this) = *((Thread*)&right);
	_server          = right._server;
	return *this;
    }
    DBool      MultiClientServer::operator  ==(const MultiClientServer & right ) const 
    {
	DBool aBool = *((Thread*)this)== *((Thread*)&right);
	aBool      |= _server         == right._server;
	return aBool;
    }
    DBool      MultiClientServer::operator  !=(const MultiClientServer & right ) const 
    {
	DBool aBool = *((Thread*)this)!= *((Thread*)&right);
	aBool      |= _server         != right._server;
	return aBool;
    }
    void MultiClientServer::run()
    {
    }
}
