#ifndef __DAQBuilderMultiClientServer_HH__
#define __DAQBuilderMultiClientServer_HH__
#include <System/DAQBuilderThread.hh>
#include <Util/DAQBuilderSmartPointer.hh>
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class MultiClientServer : public Thread
  {
  protected:
    void              _setType();
    void              _setParentClasses();
  public:
    const  DString           toString() const ;
  protected:
    SmartPointer      _server;
    fd_set            _fdSet;
  protected:
  public :
    MultiClientServer( const DInt& localPort );
    MultiClientServer( const MultiClientServer& right );
    ~MultiClientServer();
  public:    
    MultiClientServer& operator   =(const MultiClientServer & right );
    virtual DBool      operator  ==(const MultiClientServer & right ) const ;
    virtual DBool      operator  !=(const MultiClientServer & right ) const ;
  public:
    virtual void run();
  };
  inline void   MultiClientServer::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline void   MultiClientServer::_setType()
  {
    this -> _type = "MultiClientServer";
  }
}
#endif
