#include <System/Network/DAQBuilderServerSocket.hh>
namespace DAQBuilder
{
  const  DString           ServerSocket::toString() const 
  {
    DString aString ;//= _toStringHeader();
    //aString         += _toStringFooter();
    return aString;
  }
  void      ServerSocket::_init( const DInt & _localPort )
    throw( IOException * )
  {
    _socketFD = ::socket(PF_INET , SOCK_STREAM , 0 );
   ::bzero((DChar*)&_socketAddress._socketAddress4,sizeof(_socketAddress._socketAddress4));
   _socketAddress._isIPV6                        = false;
   _socketAddress._hostName                      = "localhost";
   _socketAddress._port                          = _localPort;
   _socketAddress._socketAddress4.sin_family     = PF_INET; 
   _socketAddress._socketAddress4.sin_addr.s_addr= htonl(INADDR_ANY);
   _socketAddress._socketAddress4.sin_port       = htons(_socketAddress._port);
   bind(_socketAddress);
   if(::listen(_socketFD,_backLog)==-1)
     {
      IOException * e = new IOException(strerror(errno));
      DString aLocation ="ServerSocket::_init( const DInt& )";
      aLocation        += __LINE__;
      e -> insert("Location",aLocation);
      throw e;    
     }
   _isClosed= false;
  }
  Socket       ServerSocket::accept()
    throw( IOException * )
  {
    FileDescriptor aFD = -1;
    if(_socketAddress._isIPV6)
       aFD = ::accept(_socketFD,NULL,NULL);//,(struct sockaddr*)&_socketAddress._socketAddress6, sizeof(_socketAddress._socketAddress6));
    else
       aFD = ::accept(_socketFD,NULL,NULL);//(struct sockaddr*)&_socketAddress._socketAddress4, sizeof(_socketAddress._socketAddress4));
   if(aFD==-1)
     {
      IOException * e = new IOException(strerror(errno));
      DString aLocation ="ServerSocket::accept()";
      aLocation        += __LINE__;
      e -> insert("Location",aLocation);
      throw e;    
     }
    Socket aSocket(_socketAddress);   
    aSocket._socketFD = aFD;
    aSocket._isClosed = false;
    union {
      struct sockaddr sa;
      DChar           data[128];
    }un;
    socklen_t len;
    if(getpeername(aSocket._socketFD,(struct sockaddr*)un.data,&len)==-1)
      {
	IOException * e = new IOException(strerror(errno));
	DString aLocation ="ServerSocket::accept()";
	aLocation        += __LINE__;
	e -> insert("Location",aLocation);
	throw e;    
      }
    if(_socketAddress._isIPV6){
      bcopy(&un,&aSocket._socketAddress._socketAddress6,len);
    }
    else{
      bcopy(&un,&aSocket._socketAddress._socketAddress4,len);
    }
    aSocket._socketAddress._port     =  aSocket._socketAddress.getPort();
    aSocket._socketAddress._hostName =  aSocket._socketAddress.getAddress();
    return aSocket; 
  }
  void         ServerSocket::bind( const SocketAddress& socketAddress , const DInt& backLog  )
    throw( IOException * )
  {
    _socketAddress = socketAddress;
    _backLog       = backLog;
    DInt aInt=-1;
  if( _socketAddress._isIPV6 ){
     aInt = ::bind( _socketFD , (struct sockaddr*)&_socketAddress._socketAddress6 , sizeof(sockaddr_in6));
    }  
    else {
     aInt = ::bind( _socketFD , (struct sockaddr*)&_socketAddress._socketAddress4 , sizeof(sockaddr_in));
    }
    if( aInt != 0 ){
      IOException * e = new IOException(strerror(errno));
      DString aLocation ="ServerSocket::bind( const SocketAddress& )";
      aLocation        += __LINE__;
      e -> insert("Location",aLocation);
      throw e;    
    }
    
  }
  void         ServerSocket::close()
    throw( IOException * )
  {
    if(!_isClosed ){
      if( ::close(_socketFD) == -1 )
	{
	  IOException * e = new IOException(strerror(errno));
	  DString aLocation ="Socket::close()";
	  aLocation        += __LINE__;
	  e -> insert("Location",aLocation);
	  throw e;    
	}
       _isClosed = true;
    }
  }
  DBool        ServerSocket::isClosed()
  {
   return _isClosed;
  }
  const DInt                   ServerSocket::getLocalPort()          const 
  {
    return _socketAddress.getPort();
  }

  const SocketAddress&         ServerSocket::getLocalSocketAddress() const 
  {
    return _socketAddress;
  }

  ServerSocket::ServerSocket( const DInt& _localPort , const DInt& backLog  )
    :Object(),_socketFD(-1),_isClosed(true),_backLog(backLog)
  {
    _setType();
    _setParentClasses();
    _init(_localPort);
  }

  ServerSocket::ServerSocket( const ServerSocket& right )
    :Object(*((Object*)&right)),_socketFD(right._socketFD),_socketAddress(right._socketAddress),
     _isClosed(right._isClosed),_backLog(right._backLog)
  {
    _setType();
    _setParentClasses();
  }
  ServerSocket::~ServerSocket()
  {
    _finalize();
  }
  ServerSocket& ServerSocket::operator   =(const ServerSocket & right )
  {
    *((Object*)this) = *((Object*)&right);
    _socketAddress   = right._socketAddress;
    _socketFD        = right._socketFD;
    _isClosed        = right._isClosed;
    _backLog         = right._backLog;
    return *this;
  }
  DBool ServerSocket::operator          ==(const ServerSocket & right ) const 
  {
    DBool aBool = *((Object*)this) == *((Object*)&right);
    aBool      |= _socketAddress  == right._socketAddress;
    aBool      |= _socketFD       == right._socketFD;
    aBool      |= _isClosed       == right._isClosed;
    aBool      |= _backLog        == right._backLog;
    return aBool;
  }
  DBool ServerSocket::operator          !=(const ServerSocket & right ) const 
  {
    DBool aBool = *((Object*)this) != *((Object*)&right);
    aBool      |= _socketAddress   != right._socketAddress;
    aBool      |= _socketFD        != right._socketFD;
    aBool      |= _isClosed        != right._isClosed;
    aBool      |= _backLog         != right._backLog;
    return aBool;
  }
}
