#ifndef __DAQBuilderServerSocket_HH__
#define __DAQBuilderServerSocket_HH__
#include <DAQBuilderObject.hh>
#include <System/Network/DAQBuilderSocket.hh>
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class ServerSocket : public Object 
  {
  protected:
    void              _setType();
    void              _setParentClasses();
  public:
    const  DString           toString() const ;
  protected:
    FileDescriptor    _socketFD;
    SocketAddress     _socketAddress;
    DBool             _isClosed;
    DInt              _backLog;
  protected:
  void                _init( const DInt & _localPort )
      throw( IOException * );
  public:
    Socket       accept()
      throw( IOException * );
    void         bind( const SocketAddress& _socketAddress , const DInt& _backLog = 5 )
      throw( IOException * );
    void         close()
      throw( IOException * );
    DBool        isClosed();
    const DInt                   getLocalPort()          const ;
    const SocketAddress&         getLocalSocketAddress() const ;
  public :
    ServerSocket( const DInt& _localPort , const DInt& _backLog = 5 );
    ServerSocket( const ServerSocket& right );
    ~ServerSocket();
  public:    
    virtual ServerSocket& operator   =(const ServerSocket & right );
    virtual DBool operator          ==(const ServerSocket & right ) const ;
    virtual DBool operator          !=(const ServerSocket & right ) const ;
  };
  inline void   ServerSocket::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline void   ServerSocket::_setType()
  {
    this -> _type = "ServerSocket";
  }
}
#endif
