#include <System/Network/DAQBuilderSocket.hh>
#include <System/DAQBuilderSystem.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  void            Socket::_finalize() 
  {
    try{
    close();
    }catch( IOException * e ){
      System::err.println(e);
      delete e;
    }
  }
  const  DString           Socket::toString() const 
  {
    DString aString ;//= _toStringHeader();
    aString        += "FileDescriptor : ";
    aString        += String::digitToString((DLong)_socketFD);
    aString        += "\n";
    aString        += "isClosed    : ";
    aString        += _isClosed ?  "true" : "false";
    aString        += "\n";
    aString        += _socketAddress.toString();
   // aString        += _toStringFooter();
    return aString;
  }
  DBool             Socket::equals( const Object * o ) const 
  {
    if(!findParent(_type,o)) 
      return false;
    return equals(*(Socket*)o);
    
  }
  DBool             Socket::equals( const Socket & o ) const 
  {
    return  _socketAddress.equals(o._socketAddress);
  }
  void                      Socket::bind( const SocketAddress& bindPoint )
    throw (IOException *)
  {
    DInt aInt=-1;
  if( bindPoint._isIPV6 ){
     aInt = ::bind( _socketFD , (struct sockaddr*)&bindPoint._socketAddress6 , sizeof(sockaddr_in6));
    }  
    else {
     aInt = ::bind( _socketFD , (struct sockaddr*)&bindPoint._socketAddress4 , sizeof(sockaddr_in));
    }
    if( aInt != 0 ){
      IOException * e = new IOException(strerror(errno));
      DString aLocation ="Socket::bind( const SocketAddress& )";
      aLocation        += __LINE__;
      e -> insert("Location",aLocation);
      throw e;    
    }
  } 
  void                      Socket::shutdownRead()
     throw (IOException *)
 {
      if( ::shutdown(_socketFD,SHUT_RD) == -1 )
	{
	  IOException * e = new IOException(strerror(errno));
	  DString aLocation ="Socket::shutdownRead()";
	  aLocation        += __LINE__;
	  e -> insert("Location",aLocation);
	  throw e;    
	}
  }
  void                      Socket::shutdownWrite()
      throw (IOException *)
 {
      if( ::shutdown(_socketFD,SHUT_WR) == -1 )
	{
	  IOException * e = new IOException(strerror(errno));
	  DString aLocation ="Socket::shutdownWrite()";
	  aLocation        += __LINE__;
	  e -> insert("Location",aLocation);
	  throw e;    
	}
  }
  void                      Socket::shutdownReadWrite()
      throw (IOException *)
 {
      if( ::shutdown(_socketFD,SHUT_RDWR) == -1 )
	{
	  IOException * e = new IOException(strerror(errno));
	  DString aLocation ="Socket::shutdownReadWrite()";
	  aLocation        += __LINE__;
	  e -> insert("Location",aLocation);
	  throw e;    
	}
  }
  void                      Socket::close()
    throw (IOException *)
  {
    //System::out.print(this);
    //System::out.println("Call close");
    if(!_isClosed ){
      if( ::close(_socketFD) == -1 )
	{
	  IOException * e = new IOException(strerror(errno));
	  DString aLocation ="Socket::close()";
	  aLocation        += __LINE__;
	  e -> insert("Location",aLocation);
	  throw e;    
	}
      _isClosed = true;
    }
  }
  DBool                     Socket::isClosed()
  {
    return _isClosed;
  }
  const SocketAddress  &    Socket::getSocketAddress() const 
  {
    return _socketAddress;
  }
  void                      Socket::connect()
    throw (IOException * )
  {
    DInt aInt=-1;
   //std::cout<< &_socketAddress << std::endl;
  if( _socketAddress._isIPV6 ){
     aInt = ::connect( _socketFD , (struct sockaddr*)&_socketAddress._socketAddress6 , sizeof(_socketAddress._socketAddress6));
     /*DChar buf[256];
     std::cout<< inet_ntop( AF_INET6 , &_socketAddress._socketAddress6.sin6_addr , buf , 256 ) <<std::endl;
     std::cout<< buf << std::endl;
     */
    }  
    else {
     aInt = ::connect( _socketFD , (struct sockaddr*)&_socketAddress._socketAddress4 , sizeof(_socketAddress._socketAddress4));
     /*DChar buf[256];
     std::cout<< inet_ntop( AF_INET , &_socketAddress._socketAddress4.sin_addr , buf , 256 ) <<std::endl;
     std::cout<< buf << std::endl;
     */
    }
    if( aInt != 0 ){
      IOException * e = new IOException(strerror(errno));
      DString aLocation ="Socket::connect()";
      aLocation        += __LINE__;
      e -> insert("Location",aLocation);
      throw e;    
    }
    /*DByte buf[256 ];
    std::cout<< String::digitToString((DLong)::read(_socketFD,buf,256))<<std::endl;
    perror("read");
    */
    _isClosed = false;
  }
  
  Socket::Socket( const DString& host , const DInt & port )
    throw( IOException * )
    :Object(),_socketFD(-1),_socketAddress( SocketAddress(host,port) ),
     _isClosed(true)
  {
    _setType();
    _setParentClasses();
    if( _socketAddress._isIPV6 )
     _socketFD = ::socket(PF_INET6 , SOCK_STREAM , 0 );
    else 
     _socketFD = ::socket(PF_INET  , SOCK_STREAM , 0 );
  }
  Socket::Socket( const SocketAddress&   socketAddress )
    throw( IOException * )
    :Object(),_socketFD(-1),_socketAddress( socketAddress ),
     _isClosed(true)
  {
    _setType();
    _setParentClasses();
    if( _socketAddress._isIPV6 )
     _socketFD = ::socket(PF_INET6 , SOCK_STREAM , 0 );
    else 
     _socketFD = ::socket(PF_INET  , SOCK_STREAM , 0 );
   
  }
  Socket::Socket( const Socket& right )
    throw( IOException * )
    :Object(*((Object*)&right)),_socketFD(right._socketFD),_socketAddress( right._socketAddress ),
     _isClosed(right._isClosed)
  {
    //_setType();
    //_setParentClasses();
  }
  Socket::~Socket()
  {
    _finalize();
  }

  Socket& Socket::operator   =(const Socket & right )
    throw( IOException * )
  {
    *((Object*)this) = *((Object*)&right);
    _socketFD      = right._socketFD;
    _socketAddress = right._socketAddress;
    _isClosed      = right._isClosed;
    return *this;
  }
  DBool Socket::operator   ==(const Socket & right ) const 
  {
    DBool aBool = *((Object*)this)== *((Object*)&right);
    aBool      |= _socketFD      == right._socketFD;
    aBool      |= _socketAddress == right._socketAddress;
    aBool      |= _isClosed      == right._isClosed;
    return aBool;
  }
  DBool Socket::operator   !=(const Socket & right ) const 
  {
    DBool aBool = *((Object*)this)!= *((Object*)&right);
    aBool      |= _socketFD      != right._socketFD;
    aBool      |= _socketAddress != right._socketAddress;
    aBool      |= _isClosed      != right._isClosed;
    return aBool;
  }
}
