#ifndef __DAQBuilderSocket_HH__
#define __DAQBuilderSocket_HH__
#include <DAQBuilderObject.hh>
#include <System/Network/DAQBuilderSocketAddress.hh>

namespace DAQBuilder
{
  class ServerSocket;
  class SocketInputStream;
  class SocketOutputStream;
  class Socket : public Object 
  {
  friend class SocketInputStream;
  friend class SocketOutputStream;
  friend class ServerSocket;
  friend class MultiClientServer;
  protected:
    void                   _setType();
    void                   _setParentClasses();
    void                   _finalize();
  protected:
    FileDescriptor        _socketFD;
    SocketAddress         _socketAddress;
    DBool                 _isClosed;
  public:
    const  DString           toString() const ;
    DBool             equals( const Object * o ) const ;
    DBool             equals( const Socket & o ) const ;
  public:
    void                      bind( const SocketAddress& bindPoint )
      throw (IOException *);
    void                      close()
      throw (IOException *);
    void                      shutdownRead()
      throw (IOException *);
    void                      shutdownWrite()
      throw (IOException *);
    void                      shutdownReadWrite()
      throw (IOException *);
    DBool                     isClosed();
    void                      connect()
      throw (IOException * );
    //    const DInt                getLocalPort();
    const DInt                getPort() const ;
    const SocketAddress  &    getSocketAddress() const ;
  public :
    Socket( const DString& host , const DInt & port )
    throw( IOException * );
    Socket( const SocketAddress&   _socketAddress )
    throw( IOException * );
    Socket( const Socket& right )
    throw( IOException * );
    ~Socket();
  public:    
    Socket& operator   =(const Socket & right )
     throw( IOException * );
    virtual DBool operator   ==(const Socket & right ) const ;
    virtual DBool operator   !=(const Socket & right ) const ;
  };
  inline void   Socket::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline void   Socket::_setType()
  {
    this -> _type = "Socket";
  }
}
#endif
