#include <System/Network/DAQBuilderSocketAddress.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  struct hostent*            SocketAddress::_init() const 
  {
    ::bzero(&_socketAddress4,sizeof(_socketAddress4));
    ::bzero(&_socketAddress6,sizeof(_socketAddress6));
    struct hostent * aHostPointer = NULL;
    if( ( aHostPointer = ::gethostbyname(_hostName.c_str())) == NULL )
      return NULL;
    aHostPointer -> h_addrtype == AF_INET ? _isIPV6 = false : _isIPV6 = true;
    
    if(_isIPV6)
      {
        _socketAddress6.sin6_family = AF_INET6;
        ::memcpy(&(_socketAddress6.sin6_addr), aHostPointer -> h_addr , sizeof(struct in6_addr));
         _socketAddress6.sin6_port = htons(_port); 
      }
    else
      {
        _socketAddress4.sin_family = AF_INET;
        ::memcpy(&(_socketAddress4.sin_addr), aHostPointer -> h_addr , sizeof(struct in_addr));
         _socketAddress4.sin_port = htons(_port); 
      }
    return aHostPointer;
  }
  const  DString           SocketAddress::toString() const 
  {
    DString aString ;//= _toStringHeader();
    aString        += "Presentation : ";
    aString        +=  toPresentation();
    aString        += "\n";
    struct hostent* aHostAddress = _init();
    aString        += "OfficialName : ";
    aString        +=  aHostAddress->h_name; 
    aString        += "\n";
    aString        += "Address      : ";
    aString        +=  getAddress();
    aString        += "\n";
    DChar ** aCharPointerPointer;
    for(aCharPointerPointer = aHostAddress -> h_aliases ; 
	*aCharPointerPointer != NULL ;
        aCharPointerPointer++)
      {
        aString        += "Aliase       : ";
	aString        += *aCharPointerPointer ;
	aString        += "\n";
      }
    //aString += _toStringFooter();
    return aString;
  }
  
  DBool             SocketAddress::equals( const Object * o ) const 
  {
    if(!findParent(_type,o)) 
      return false;
    return equals(*(SocketAddress*)o);
  }
  
  DBool             SocketAddress::equals( const SocketAddress & o ) const
  {
    if(_isIPV6 != o._isIPV6)
      return false;
  
    if(_isIPV6)
      return(::memcmp( &_socketAddress6.sin6_addr,
		       &o._socketAddress6.sin6_addr,
		       sizeof(struct in6_addr)));
    
    else
      return(::memcmp( &_socketAddress4.sin_addr,
		       &o._socketAddress4.sin_addr,
		       sizeof(struct in_addr)));
  }
  
  const  DString           SocketAddress::toPresentation() const
  {
    DString aString = getHostName();
    aString      += ":";
    aString      += String::digitToString((DLong)getPort());
    return aString;
  }
  
  const  DString           SocketAddress::getHostName() const
  {
    return _hostName;
  }
  
  void                     SocketAddress::setHostName(  const DString& hostName )
    throw (IOException * )
  {
    _hostName = hostName;
    if(_init()==NULL){
      IOException * e = new IOException(hstrerror(h_errno));
      DString aLocation ="SocketAddress::setHostName(  const DString& hostName )";
      aLocation        += __LINE__;
      e -> insert("Location",aLocation);
      throw e;
    }
  }
  const  DString           SocketAddress::getAddress() const
  {
   DChar buf[128];
   DString aString="";
   if(_isIPV6){
     if(::inet_ntop(AF_INET6,&_socketAddress6.sin6_addr,buf,sizeof(buf))==NULL)  
       return aString;
   }
   else{
     if(::inet_ntop(AF_INET,&_socketAddress4.sin_addr,buf,sizeof(buf)) ==NULL)  
       return aString;
   }
    aString += buf; 
    return aString;
  }
  const  DInt              SocketAddress::getPort() const
  {
   DInt aInt = -1;
   if(_isIPV6){
       aInt = (DInt)ntohs(_socketAddress6.sin6_port);
   }
   else{
       aInt = (DInt)ntohs(_socketAddress4.sin_port);
   }
   return aInt;
  }
  
  void                     SocketAddress::setPort( const DInt& port )
    throw (IOException * )
  {
    _port = port;
    if(_init()==NULL){
      IOException * e = new IOException(hstrerror(h_errno));
      DString aLocation ="SocketAddress::setPort(  const DInt& port )";
      aLocation        += __LINE__;
      e -> insert("Location",aLocation);
      throw e;
    }
  }
  SocketAddress::SocketAddress( const DString& hostName , const DInt & port )
      throw (IOException * )
    :Object(),_isIPV6(false),_hostName(hostName),_port(port)
  {
    _setType();
    _setParentClasses();
    if(_init()==NULL){
      IOException * e = new IOException(hstrerror(h_errno));
      DString aLocation ="SocketAddress::setPort(  const DInt& port )";
      aLocation        += __LINE__;
      e -> insert("Location",aLocation);
      throw e;
    }
  }
  SocketAddress::SocketAddress()
      throw (IOException * )
    :Object(),_isIPV6(false),_hostName("localhost")//,_port(port)
  {
    _setType();
    _setParentClasses();
  }
  SocketAddress::SocketAddress( const DString& hostName , const DString & port )
      throw (IOException * )
    :Object(),_isIPV6(false),_hostName(hostName)//,_port(port)
  {
    _setType();
    _setParentClasses();
    if(_init()==NULL){
      IOException * e = new IOException(hstrerror(h_errno));
      DString aLocation ="SocketAddress::setPort(  const DInt& port )";
      aLocation        += __LINE__;
      e -> insert("Location",aLocation);
      throw e;
    }
  }
  
  SocketAddress::SocketAddress( const SocketAddress& right )
      throw (IOException * )
    :Object(),_isIPV6(right._isIPV6),_hostName(right._hostName),_port(right._port)
  {
    _setType();
    _setParentClasses();
    if(_init()==NULL){
      IOException * e = new IOException(hstrerror(h_errno));
      DString aLocation ="SocketAddress::setPort(  const DInt& port )";
      aLocation        += __LINE__;
      e -> insert("Location",aLocation);
      throw e;
    }
  }
  
  SocketAddress::~SocketAddress()
  {
    _finalize();
  }
  SocketAddress& SocketAddress::operator=(const SocketAddress & right )
      throw (IOException * )
  {
    *((Object*)this) = *((Object*)&right);
    _isIPV6   = right._isIPV6;
    _hostName = right._hostName;
    _port     = right._port;
    if(_init()==NULL){
      IOException * e = new IOException(hstrerror(h_errno));
      DString aLocation ="SocketAddress::setPort(  const DInt& port )";
      aLocation        += __LINE__;
      e -> insert("Location",aLocation);
      throw e;
    }
    return *this;
  }
  DBool SocketAddress::operator   ==(const SocketAddress & right ) const 
  {
    DBool aBool = *((Object*)this) == *((Object*)&right);
    aBool      |= _isIPV6  == right._isIPV6;
    aBool      |= _hostName== right._hostName;
    aBool      |= _port    == right._port;
    return aBool;
  }
  DBool SocketAddress::operator   !=(const SocketAddress & right ) const 
  {
    DBool aBool = *((Object*)this) != *((Object*)&right);
    aBool      |= _isIPV6  != right._isIPV6;
    aBool      |= _hostName!= right._hostName;
    aBool      |= _port    != right._port;
    return aBool;
  }
}
