#ifndef __DAQBuilderSocketAddress_HH__
#define __DAQBuilderSocketAddress_HH__
#include <DAQBuilderObject.hh>
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class Socket;
  class ServerSocket;
  class SocketAddress : public Object 
  {
    friend class Socket;
    friend class ServerSocket;
  protected:
    void                  _setType();
    void                  _setParentClasses();
  protected:
    mutable struct sockaddr_in    _socketAddress4;
    mutable struct sockaddr_in6   _socketAddress6;
    mutable DBool                 _isIPV6;
    DString                       _hostName;
    DInt                          _port;
  protected:
    struct hostent*                  _init() const ;
  public:
    const  DString           toString() const ;
    DBool             equals( const Object * o ) const ;
    DBool             equals( const SocketAddress & o ) const ;
  public:
    const  DString           toPresentation() const;
    const  DString           getHostName() const;
    void                     setHostName(  const DString& hostName )
      throw (IOException * );
    const  DString           getAddress() const;
    const  DInt              getPort() const;
    void                     setPort( const DInt& port )
      throw (IOException * );

  public :
    SocketAddress()
      throw (IOException * );
    SocketAddress( const DString& _host , const DInt    & _port )
      throw (IOException * );
    SocketAddress( const DString& _host , const DString & _port )
      throw (IOException * );
    SocketAddress( const SocketAddress& right )
      throw (IOException * );
    ~SocketAddress();
  public:    
    SocketAddress& operator   =(const SocketAddress & right )
      throw (IOException * );
    virtual DBool operator   ==(const SocketAddress & right ) const ;
    virtual DBool operator   !=(const SocketAddress & right ) const ;
  };
  inline void   SocketAddress::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline void   SocketAddress::_setType()
  {
    this -> _type = "SocketAddress";
  }
}
#endif
