#include <UserInterface/DAQBuilderConsoleUserInterface.hh>
#include <System/DAQBuilderObjectRegistry.hh>
#include <System/DAQBuilderActionRegistry.hh>
#include <System/DAQBuilderRunRegistry.hh>
#include <System/DAQBuilderClassLoader.hh>
#include <System/DAQBuilderCommandLoader.hh>
#include <System/DAQBuilderSystem.hh>

namespace DAQBuilder
{
  StringList               g_Commands;
  const DString  g_Action     = "Action";
  const DString  g_RunStart   = "RunStart";
  const DString  g_RunPause   = "RunPause";
  const DString  g_RunShutdown= "RunShutdown";
  const DString  g_RunResume  = "RunResume";
  const DString  g_DumpObject = "DumpObject";
  const DString  g_DumpRun    = "DumpRun";
  const DString  g_DumpAction = "DumpAction";
  const DString  g_MakeAction = "MakeAction";

  const DString  g_InstallRunBeginAction = "InstallRunBeginAction";
  const DString  g_InstallRunLoopAction  = "InstallRunLoopAction";
  const DString  g_InstallRunEndAction   = "InstallRunEndAction";

  const DString  g_bool       = "bool_";
  const DString  g_char       = "char_";
  const DString  g_uchar      = "uchar_";
  const DString  g_int        = "int_";
  const DString  g_uint       = "uint_";
  const DString  g_long       = "long_";
  const DString  g_ulong      = "ulong_";
  const DString  g_short      = "short_";
  const DString  g_ushort     = "ushort_";
  const DString  g_float      = "float_";
  const DString  g_double     = "double_";
  
  void   g_MakeCommands()
  {
    g_Commands.clear();
    DString buffer="";
    if(rl_line_buffer)
      buffer=rl_line_buffer;
    
    if(buffer.empty()){
      StringList commandList = CommandLoader::getInstalledCommandList();
      std::copy(commandList.begin(),commandList.end(),std::back_inserter(g_Commands));
      return ;
      }
    if(strncmp(buffer.c_str(),g_Action.c_str(),g_Action.length())==0){
	StringList objectList  = ObjectRegistry::getBindedObjectList();
        std::copy(objectList.begin(),objectList.end(),std::back_inserter(g_Commands));
	StringList insertList;
	for(StringList::const_iterator iter = objectList.begin(); 
	    iter != objectList.end(); iter++)
	  {
	    StringList methodList=ObjectRegistry::lookUp(*iter).getClass().getMethodList(); 
	    for(StringList::const_iterator miter = methodList.begin(); 
		miter != methodList.end(); miter++)
	      {
		DString buffer=*iter;
		buffer       +=".";
		buffer       +=*miter;
		buffer       +="(";
		insertList.push_back(buffer);
	      }
	insertList.push_back(g_bool);
	insertList.push_back(g_char);
	insertList.push_back(g_uchar);
	insertList.push_back(g_int);
	insertList.push_back(g_uint);
	insertList.push_back(g_short);
	insertList.push_back(g_ushort);
	insertList.push_back(g_long);
	insertList.push_back(g_ulong);
	insertList.push_back(g_float);
	insertList.push_back(g_double);
	  }
	std::copy(insertList.begin(),insertList.end(),std::back_inserter(g_Commands));
	return ;
     }
    if(strncmp(buffer.c_str(),g_MakeAction.c_str(),g_MakeAction.length())==0){
	StringList objectList  = ObjectRegistry::getBindedObjectList();
        std::copy(objectList.begin(),objectList.end(),std::back_inserter(g_Commands));
	StringList insertList;
	for(StringList::const_iterator iter = objectList.begin(); 
	    iter != objectList.end(); iter++)
	  {
	    StringList methodList=ObjectRegistry::lookUp(*iter).getClass().getMethodList(); 
	    for(StringList::const_iterator miter = methodList.begin(); 
		miter != methodList.end(); miter++)
	      {
		DString buffer=*iter;
		buffer       +=".";
		buffer       +=*miter;
		buffer       +="(";
		insertList.push_back(buffer);
	      }
	insertList.push_back(g_bool);
	insertList.push_back(g_char);
	insertList.push_back(g_uchar);
	insertList.push_back(g_int);
	insertList.push_back(g_uint);
	insertList.push_back(g_short);
	insertList.push_back(g_ushort);
	insertList.push_back(g_long);
	insertList.push_back(g_ulong);
	insertList.push_back(g_float);
	insertList.push_back(g_double);
	  }
	std::copy(insertList.begin(),insertList.end(),std::back_inserter(g_Commands));
	return ;
     }
    if(strncmp(buffer.c_str(),g_InstallRunBeginAction.c_str(),g_InstallRunBeginAction.length())==0){
        StringList runList  = RunRegistry::getBindedRunList();
        std::copy(runList.begin(),runList.end(),std::back_inserter(g_Commands));
	StringList objectList  = ObjectRegistry::getBindedObjectList();
        std::copy(objectList.begin(),objectList.end(),std::back_inserter(g_Commands));
	StringList insertList;
	for(StringList::const_iterator iter = objectList.begin(); 
	    iter != objectList.end(); iter++)
	  {
	    StringList methodList=ObjectRegistry::lookUp(*iter).getClass().getMethodList(); 
	    for(StringList::const_iterator miter = methodList.begin(); 
		miter != methodList.end(); miter++)
	      {
		DString buffer=*iter;
		buffer       +=".";
		buffer       +=*miter;
		buffer       +="(";
		insertList.push_back(buffer);
	      }
	insertList.push_back(g_bool);
	insertList.push_back(g_char);
	insertList.push_back(g_uchar);
	insertList.push_back(g_int);
	insertList.push_back(g_uint);
	insertList.push_back(g_short);
	insertList.push_back(g_ushort);
	insertList.push_back(g_long);
	insertList.push_back(g_ulong);
	insertList.push_back(g_float);
	insertList.push_back(g_double);
	  }
	std::copy(insertList.begin(),insertList.end(),std::back_inserter(g_Commands));
	return ;
     }
    if(strncmp(buffer.c_str(),g_InstallRunLoopAction.c_str(),g_InstallRunLoopAction.length())==0){
        StringList runList  = RunRegistry::getBindedRunList();
        std::copy(runList.begin(),runList.end(),std::back_inserter(g_Commands));
	StringList objectList  = ObjectRegistry::getBindedObjectList();
        std::copy(objectList.begin(),objectList.end(),std::back_inserter(g_Commands));
	StringList insertList;
	for(StringList::const_iterator iter = objectList.begin(); 
	    iter != objectList.end(); iter++)
	  {
	    StringList methodList=ObjectRegistry::lookUp(*iter).getClass().getMethodList(); 
	    for(StringList::const_iterator miter = methodList.begin(); 
		miter != methodList.end(); miter++)
	      {
		DString buffer=*iter;
		buffer       +=".";
		buffer       +=*miter;
		buffer       +="(";
		insertList.push_back(buffer);
	      }
	insertList.push_back(g_bool);
	insertList.push_back(g_char);
	insertList.push_back(g_uchar);
	insertList.push_back(g_int);
	insertList.push_back(g_uint);
	insertList.push_back(g_short);
	insertList.push_back(g_ushort);
	insertList.push_back(g_long);
	insertList.push_back(g_ulong);
	insertList.push_back(g_float);
	insertList.push_back(g_double);
	  }
	std::copy(insertList.begin(),insertList.end(),std::back_inserter(g_Commands));
	return ;
     }
    if(strncmp(buffer.c_str(),g_InstallRunEndAction.c_str(),g_InstallRunEndAction.length())==0){
        StringList runList  = RunRegistry::getBindedRunList();
        std::copy(runList.begin(),runList.end(),std::back_inserter(g_Commands));
	StringList objectList  = ObjectRegistry::getBindedObjectList();
        std::copy(objectList.begin(),objectList.end(),std::back_inserter(g_Commands));
	StringList insertList;
	for(StringList::const_iterator iter = objectList.begin(); 
	    iter != objectList.end(); iter++)
	  {
	    StringList methodList=ObjectRegistry::lookUp(*iter).getClass().getMethodList(); 
	    for(StringList::const_iterator miter = methodList.begin(); 
		miter != methodList.end(); miter++)
	      {
		DString buffer=*iter;
		buffer       +=".";
		buffer       +=*miter;
		buffer       +="(";
		insertList.push_back(buffer);
	      }
	insertList.push_back(g_bool);
	insertList.push_back(g_char);
	insertList.push_back(g_uchar);
	insertList.push_back(g_int);
	insertList.push_back(g_uint);
	insertList.push_back(g_short);
	insertList.push_back(g_ushort);
	insertList.push_back(g_long);
	insertList.push_back(g_ulong);
	insertList.push_back(g_float);
	insertList.push_back(g_double);
	  }
	std::copy(insertList.begin(),insertList.end(),std::back_inserter(g_Commands));
	return ;
     }
    if(strncmp(buffer.c_str(),g_RunStart.c_str(),g_RunStart.length())==0){
        StringList runList  = RunRegistry::getBindedRunList();
        std::copy(runList.begin(),runList.end(),std::back_inserter(g_Commands));
	return ;
     }
    if(strncmp(buffer.c_str(),g_RunPause.c_str(),g_RunPause.length())==0){
        StringList runList  = RunRegistry::getBindedRunList();
        std::copy(runList.begin(),runList.end(),std::back_inserter(g_Commands));
	return ;
     }
    if(strncmp(buffer.c_str(),g_RunResume.c_str(),g_RunResume.length())==0){
        StringList runList  = RunRegistry::getBindedRunList();
        std::copy(runList.begin(),runList.end(),std::back_inserter(g_Commands));
	return ;
     }
    if(strncmp(buffer.c_str(),g_RunShutdown.c_str(),g_RunShutdown.length())==0){
        StringList runList  = RunRegistry::getBindedRunList();
        std::copy(runList.begin(),runList.end(),std::back_inserter(g_Commands));
	return ;
     }
    if(strncmp(buffer.c_str(),g_DumpObject.c_str(),g_DumpObject.length())==0){
    StringList objectList  = ObjectRegistry::getBindedObjectList();
    std::copy(objectList.begin(),objectList.end(),std::back_inserter(g_Commands));
	return ;
     }
    if(strncmp(buffer.c_str(),g_DumpRun.c_str(),g_DumpRun.length())==0){
    StringList runList  = RunRegistry::getBindedRunList();
    std::copy(runList.begin(),runList.end(),std::back_inserter(g_Commands));
	return ;
     }
    if(strncmp(buffer.c_str(),g_DumpAction.c_str(),g_DumpAction.length())==0){
    StringList actionList  = ActionRegistry::getBindedActionList();
    std::copy(actionList.begin(),actionList.end(),std::back_inserter(g_Commands));
	return ;
     }
    StringList classList   = ClassLoader::getInstalledClassList();
    std::copy(classList.begin(),classList.end(),std::back_inserter(g_Commands));

    StringList commandList = CommandLoader::getInstalledCommandList();
    std::copy(commandList.begin(),commandList.end(),std::back_inserter(g_Commands));

    StringList objectList  = ObjectRegistry::getBindedObjectList();
    std::copy(objectList.begin(),objectList.end(),std::back_inserter(g_Commands));

    StringList actionList  = ActionRegistry::getBindedActionList();
    std::copy(actionList.begin(),actionList.end(),std::back_inserter(g_Commands));

    StringList runList  = RunRegistry::getBindedRunList();
    std::copy(runList.begin(),runList.end(),std::back_inserter(g_Commands));
  }
  
  char * g_CommandGenerator( const char * text , int state )
  {
    static unsigned int  listIndex;
    static unsigned int  length;
    DString name;
    if(!state)
      {
	listIndex = 0;
	length = strlen(text);
      }
    while(listIndex < g_Commands.size())
      {
	name = g_Commands[listIndex];
	listIndex++;
	if( strncmp(name.c_str(),text,length)==0)
	  {
	    char * tmp = new char[name.length()+1];
	    strcpy(tmp,name.c_str());
	    return tmp;
	  }
      }
    return (char*)NULL;
  }
  
  char ** g_Completion(const char * text , int start , int end )
  {

    char ** matches = (char **)NULL;
    g_MakeCommands();
    matches = rl_completion_matches(text,g_CommandGenerator);
    return matches;
  }
  
  void g_Initialize()
  {
    rl_attempted_completion_function = g_Completion;
  }
  
  ConsoleUserInterface::ConsoleUserInterface( const DString& prompt )
    :UserInterface(),_prompt(prompt)
  {
    g_Initialize();
    _setType();
    _setParentClasses();
  }
  
  void ConsoleUserInterface::run()
  {
    while(true)
      {
	DString line = getLine();
        //std::cout<<"line="<<line<<std::endl;
	if( line == "exit")
	  { 
	    break;
	  }
	
	if( !line.empty() )
	  {
	    DString::iterator iter = line.end();
	    iter--;
	    if(*iter=='\0')
	      {
		line.erase(iter);
	      }
       //_lock();
	//    System::command.println(line);
	    System::command.print(line);
       //_unLock();
	  }
      }
  }
  
  const DString& ConsoleUserInterface::getPrompt() const 
  {
    return this -> _prompt;
  }
  void               ConsoleUserInterface::setPrompt( const DString & _prompt )
  {
    _lock();
    this -> _prompt.clear();
    this -> _prompt = _prompt;
    _unLock();
  }
  DString               ConsoleUserInterface::getLine()
  {
    _lock();
    //g_MakeCommands();
    DString buffer(readline(_prompt.c_str()));
    if(!buffer.empty())
      {
	if(buffer[0] != '\0' )
	  {
	    add_history(buffer.c_str());
	  }
      }
    _unLock();
    return buffer;
  }
  
  DBool               ConsoleUserInterface::put( const DString & line )
  {
    _lock();
    System::out.print(line);
    _unLock();
    return true;
  }
}
