#ifndef  _DAQBuilderConsoleUserInterface_HH
#define  _DAQBuilderConsoleUserInterface_HH
#include <UserInterface/DAQBuilderUserInterface.hh>

namespace DAQBuilder
{
  class ConsoleUserInterface : public UserInterface
  {
  protected:
    virtual               void _finalize();

    virtual  void              _setType();
    virtual  void              _setParentClasses();
  protected :
    DString               _prompt;
  public :
    ConsoleUserInterface( const DString& _prompt ="$ ");
    ConsoleUserInterface( const ConsoleUserInterface& right);
    virtual ~ConsoleUserInterface();
    virtual ConsoleUserInterface& operator=( const ConsoleUserInterface& right );
  public :
    virtual  const DString toString() const ;
    virtual void               run();
    virtual const DString& getPrompt() const ;
    virtual void               setPrompt( const DString & _prompt );
    virtual DString        getLine();
    virtual DBool               put( const DString & line );
  };
  inline ConsoleUserInterface::~ConsoleUserInterface()
  {
    _finalize();
  }
  inline void ConsoleUserInterface::_finalize()
  {
    _lock();
    _prompt.clear();
    _unLock();
  }
  inline const DString ConsoleUserInterface::toString() const 
  {
    DString returnString = "";
    return returnString;
  }
  inline void              ConsoleUserInterface::_setType()
  {
    this -> _type="ConsoleUserInterface";
  }
  inline void              ConsoleUserInterface::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Runnable");
    _parentClasses.insert("Thread");
    _parentClasses.insert("UserInterface");
 } 
 inline ConsoleUserInterface::ConsoleUserInterface( const ConsoleUserInterface& right)
  :UserInterface(*((UserInterface*)&right)),_prompt(right._prompt)
 {
 }
 inline ConsoleUserInterface& ConsoleUserInterface::operator=( const ConsoleUserInterface& right)
 {
   *((UserInterface*)this)= *((UserInterface*)&right);
   _prompt = right._prompt;
   return *this;
 }
}
#endif
