#ifndef __DAQBuilderUserInterface_HH__
#define __DAQBuilderUserInterface_HH__
#include <System/DAQBuilderThread.hh>

namespace DAQBuilder
{
  class UserInterface : public Thread
  {
  protected:
    virtual               void _finalize();
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :
    UserInterface();
    UserInterface( const UserInterface& right);
      virtual ~UserInterface();
    virtual UserInterface& operator =( const UserInterface& right );
  public:
    virtual  const DString  toString() const ;
  };
  inline UserInterface::UserInterface()
    :Thread()
  {
    _setType();
   _setParentClasses();
  }
  inline UserInterface::UserInterface( const UserInterface& right)
    :Thread(*((Thread*)&right))
  {
    _setType();
   _setParentClasses();
  }
  inline UserInterface& UserInterface::operator =( const UserInterface& right )
  {
    *((Thread*)this) =  *((Thread*)&right);
    return *this;
  }
  inline UserInterface::~UserInterface()
  {
    _finalize();
  }
  inline void UserInterface::_finalize()
  {
    ;
  }
  inline const DString UserInterface::toString() const 
  {
    DString returnString;
    return returnString;
  }
  inline void              UserInterface::_setType()
  {
    this -> _type="UserInterface";
  }
  inline void              UserInterface::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Runnable");
    _parentClasses.insert("Thread");
 } 
}
#endif
