#include <Util/DAQBuilderClock.hh>
namespace DAQBuilder
{
  void Clock::_drawTickAt(GdkGC * gc , DInt hour )
  {
    double hourRadians = hour * 3.14 / 6.0 ;
    GtkStyle * defstyle = gtk_widget_get_default_style();
    GdkFont * font = defstyle->font;//gdk_fontset_load("-*-helvetica-medium-r-normal--*-120-*-*-*-*-*-*(null)");
    char _hourChar[255] ;
    sprintf(_hourChar,"%d",hour);
    gdk_draw_string(_pixmap,
		    font,
		    gc,
		    _centerX+(int)(0.9 * _radius * sin(hourRadians)),
		    _centerY-(int)(0.9 * _radius * cos(hourRadians)),
		    _hourChar);
    if(hour%3 == 0)
      gdk_draw_line( _pixmap , 
		     gc , 
		     _centerX+(int)(0.9 * _radius * sin(hourRadians)),_centerY-(int)(0.9 * _radius * cos(hourRadians)),
		     _centerX+(int)(1.0 * _radius * sin(hourRadians)),_centerY-(int)(1.0 * _radius * cos(hourRadians)));
    else
      gdk_draw_line( _pixmap , 
		     gc , 
		     _centerX+(int)(0.95 * _radius * sin(hourRadians)),_centerY-(int)(0.95 * _radius * cos(hourRadians)),
		     _centerX+(int)(1.0 * _radius * sin(hourRadians)),_centerY-(int)(1.0 * _radius * cos(hourRadians)));
  }
  
  void Clock::_drawSec( GdkGC * gc )
  {
    double secRadians = _nSec * 3.14/ 30;
    gdk_draw_line( _pixmap , 
		   gc , 
		   _centerX,_centerY,
		   _centerX+(int)(0.9 * _radius * sin(secRadians)),_centerY-(int)(0.9 * _radius * cos(secRadians)));
  }
  
  void Clock::_drawMin( GdkGC * gc )
  {
    double minRadians = _nMin * 3.14/ 30 + _nSec  * 3.14/ 1800.0;
    gdk_draw_line( _pixmap , 
		   gc , 
		   _centerX,_centerY,
		   _centerX+(int)(0.75 * _radius * sin(minRadians)),_centerY-(int)(0.75 * _radius * cos(minRadians)));
  }
  
  void Clock::_drawHour( GdkGC * gc )
  {
    double hourRadians = _nHour * 3.14/ 6.0 + _nMin  * 3.14/ 360.0;
    
    gdk_draw_line( _pixmap , 
		   gc , 
		   _centerX,_centerY,
		   _centerX+(int)(0.5 * _radius * sin(hourRadians)),_centerY-(int)(0.5 * _radius * cos(hourRadians)));
  }
  gint Clock::_alarmEventEntry( gpointer clock )
  {
    Clock * c = (Clock*)clock;
    c -> _repaint();
    return TRUE;
  }
  gint Clock::_repaint()
  { 
    gdk_draw_rectangle(_pixmap,
		       _drawingArea -> style -> white_gc,
		       TRUE ,
		       0,0,
		       _drawingArea -> allocation.width,
		       _drawingArea -> allocation.height);
    
    _centerX =      _drawingArea -> allocation.width/2;
    _centerY =      _drawingArea -> allocation.height/2;
    
    _radius  = MIN(_centerX,_centerY);
    
    gdk_draw_arc(_pixmap,
		 _drawingArea -> style -> black_gc,
		 FALSE, 
		 0,0,
		 _centerX*2,_centerY*2,
		 0,360*64);
    DInt hour =0;
    for( hour = 1 ; hour <= 12 ; hour++ )
      {
	this -> _drawTickAt(_drawingArea -> style ->black_gc, hour);
      }
    
    time_t      now;
    struct tm * nowTime;
    time(&now);
    
    nowTime = localtime(&now);
    
    char  whatTimeIsItNow[255];
    _nHour = nowTime -> tm_hour;
    _nMin  = nowTime -> tm_min;
    _nSec  = nowTime -> tm_sec;
    sprintf( whatTimeIsItNow,"%2d:%2d:%2d",
	     _nHour,

	     _nMin,
	     _nSec);
    
    this -> _drawSec(_drawingArea -> style ->black_gc);
    
    this -> _drawMin(_drawingArea -> style ->black_gc);
    
    this -> _drawHour(_drawingArea -> style ->black_gc);
    
    GtkStyle * defstyle = gtk_widget_get_default_style();
    GdkFont * font = defstyle->font;//gdk_fontset_load("-*-helvetica-medium-r-normal--*-120-*-*-*-*-*-*(null)");
    //GdkFont * font = gdk_fontset_load("-*-helvetica-medium-r-normal--*-120-*-*-*-*-*-*(null)");
    
    gdk_draw_string(_pixmap, 
		    font,
		    _drawingArea -> style -> black_gc,
		    _centerX*3/4,_centerY,
		    whatTimeIsItNow);
    
    GdkRectangle    updateRect;
    
    updateRect.x= 0;
    updateRect.y= 0;
    updateRect.width= _drawingArea->allocation.width;
    updateRect.height= _drawingArea->allocation.height;
    gtk_widget_draw(_drawingArea,&updateRect);
    return (gint)TRUE;
  }
  
  gint Clock::_configureEventEntry(GtkWidget * widget , GdkEventConfigure * event , gpointer clock )
  {
    Clock *c = (Clock*)clock;
    if(c->_pixmap)
      {
	gdk_pixmap_unref(c->_pixmap);
      }
    
    c->_pixmap= gdk_pixmap_new(widget -> window , 
			       widget -> allocation.width ,
			       widget -> allocation.height , 
			       -1);
    return TRUE;
  }
  
  gint Clock::_exposeEventEntry(GtkWidget * widget , GdkEventExpose * event , gpointer clock )
  {
    Clock *c = (Clock*)clock;

    gdk_draw_pixmap(widget -> window,
		    widget -> style -> fg_gc[GTK_WIDGET_STATE(widget)],
		    c->_pixmap,
		    event -> area.x , event -> area.y,
		    event -> area.x , event -> area.y,
		    event -> area.width , event -> area.height);
  return FALSE;
  }
  
  gint Clock::_destroyEventEntry(gpointer g )
  { 
    gtk_exit(0);
    return TRUE;
  }
  
  const DString Clock::_toString() const 
  {
    DString returnString;
    return returnString;
  }

  void              Clock::_setType()
  {
    _type ="Clock";
  }

  void              Clock::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Runnable");
    _parentClasses.insert("Thread");
  }
  
  Clock::Clock()
    :Thread(),_pixmap(NULL),_drawingArea(NULL),_window(NULL),_vbox(NULL),
     _radius(0),_nHour(0),_nMin(0),_nSec(0),_centerX(0),_centerY(0)
  {
    _setType();
    _setParentClasses();
  }

  Clock::Clock( const Clock& right )
    :Thread(*((Thread*)&right)),_pixmap(right._pixmap),_drawingArea(right._drawingArea),
     _window(right._window),_vbox(right._vbox),_radius(right._radius),
     _nHour(right._nHour),_nMin(right._nMin),_nSec(right._nSec),
     _centerX(right._centerX),_centerY(right._centerY)
  {
    _window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    _vbox   = gtk_hbox_new(FALSE,0);
    _drawingArea = gtk_drawing_area_new();
    
    
    gtk_signal_connect(GTK_OBJECT(_window),"destroy",
		       GTK_SIGNAL_FUNC(Clock::_destroyEventEntry),NULL);
    
    gtk_signal_connect(GTK_OBJECT(_drawingArea),"expose_event",
		       GTK_SIGNAL_FUNC(Clock::_exposeEventEntry),(gpointer)this);
    
    gtk_signal_connect(GTK_OBJECT(_drawingArea),"configure_event",
		       GTK_SIGNAL_FUNC(_configureEventEntry),(gpointer)this);
    
    gtk_timeout_add(1,Clock::_alarmEventEntry,(gpointer)this);
    
  }
  Clock& Clock::operator=( const Clock& right )
  {
    *((Thread*)this)=    *((Thread*)&right);
    _pixmap         =    right._pixmap;
    _drawingArea    = right._drawingArea;
    _window         = right._window;
    _vbox           = right._vbox;
    _radius         = right._radius;
    _nHour          = right._nHour;
    _nMin           = right._nMin;
    _nSec           = right._nSec;
    _centerX        = right._centerX;
    _centerY        = right._centerY;
    _window         = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    _vbox           = gtk_hbox_new(FALSE,0);
    _drawingArea    = gtk_drawing_area_new();
    
    
    gtk_signal_connect(GTK_OBJECT(_window),"destroy",
		       GTK_SIGNAL_FUNC(Clock::_destroyEventEntry),NULL);
    
    gtk_signal_connect(GTK_OBJECT(_drawingArea),"expose_event",
		       GTK_SIGNAL_FUNC(Clock::_exposeEventEntry),(gpointer)this);
    
    gtk_signal_connect(GTK_OBJECT(_drawingArea),"configure_event",
		       GTK_SIGNAL_FUNC(_configureEventEntry),(gpointer)this);
    
    gtk_timeout_add(1,Clock::_alarmEventEntry,(gpointer)this);
    return *this; 
  }
  DBool   Clock::operator   ==(const Object & right ) const 
  {
    DBool aBool = *((Object*)this) ==  *((Object*)&right);
    return aBool;
  }
  DBool   Clock::operator   !=(const Object & right ) const 
  {
    DBool aBool = *((Object*)this) !=  *((Object*)&right);
    return aBool;
  }
  Clock::~Clock()
  {
    _free();
  }
  
  void              Clock::run()
  {
    DInt processID = 0;
     processID = fork();
    if( processID == 0 )
      {
	gtk_init(0,NULL); 

	_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	_vbox   = gtk_hbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(_window),_vbox);
	gtk_widget_show(_vbox);
	
	_drawingArea = gtk_drawing_area_new();
	gtk_drawing_area_size(GTK_DRAWING_AREA(_drawingArea),200,200);    
	
	gtk_box_pack_start(GTK_BOX(_vbox),_drawingArea,TRUE,TRUE,0);
	
	
	gtk_widget_show(_drawingArea);
    
	gtk_widget_show(_window);
	
	gtk_signal_connect(GTK_OBJECT(_window),"destroy",
			   GTK_SIGNAL_FUNC(Clock::_destroyEventEntry),NULL);
	
	gtk_signal_connect(GTK_OBJECT(_drawingArea),"expose_event",
			   GTK_SIGNAL_FUNC(Clock::_exposeEventEntry),(gpointer)this);
	
	gtk_signal_connect(GTK_OBJECT(_drawingArea),"configure_event",
			   GTK_SIGNAL_FUNC(_configureEventEntry),(gpointer)this);
	
	gtk_timeout_add(10,Clock::_alarmEventEntry,(gpointer)this);
	
	_pixmap= gdk_pixmap_new(_window -> window , 
				_window -> allocation.width ,
				_window -> allocation.height , 
				-1);
	
	gtk_main();
	::exit(0);
      }
    else if( processID >= 1  )
      {
        DInt status;
	::wait(&status);
      }
    else
      {
        perror("fork");
      }
  }
  
  void  Clock::show()
  {
    start();
  }
}
