#ifndef __DAQBuilderClock_HH
#define __DAQBuilderClock_HH
#define D_USE_GTK
#include <System/DAQBuilderThread.hh>

namespace DAQBuilder
{
  class Clock : public Thread
  {
  private:
    GdkDrawable        *       _pixmap;
    GtkWidget          *       _drawingArea;
    GtkWidget          *       _window ;
    GtkWidget          *       _vbox;

    DInt                        _radius;
    DInt                        _nHour;
    DInt                        _nMin;
    DInt                        _nSec;
    DInt                        _centerX;
    DInt                        _centerY;

  protected:
    virtual  const std::string _toString() const ;
    virtual  void
    _setType();
    virtual  void              _setParentClasses();
    virtual  void              _free(){;}
  protected:
    virtual  void              _drawTickAt(GdkGC * graphicContexist, DInt hour=0);
    virtual  void              _drawHour(GdkGC * graphicContexist);
    virtual  void              _drawMin(GdkGC * graphicContexist);
    virtual  void              _drawSec(GdkGC * graphicContexist);
    virtual  gint              _repaint();
  protected:
    static   gint              _alarmEventEntry(gpointer);
    static   gint              _configureEventEntry(GtkWidget * widget , GdkEventConfigure * event , gpointer clock );
    static   gint              _exposeEventEntry(GtkWidget * widget , GdkEventExpose * event , gpointer clock );
    static   gint              _destroyEventEntry(gpointer);
  public:
    Clock();
    Clock( const Clock& right );
    virtual ~Clock();
    virtual Clock& operator     =( const Clock& right );
    virtual DBool   operator   ==(const Object & right ) const ;
    virtual DBool   operator   !=(const Object & right ) const ;
    virtual  void              run();
  public:
    void  show();
  };
}
#endif
