#include <Util/DAQBuilderCommentEraser.hh>
#include <Util/DAQBuilderCommentStateBase.hh>
#include <Util/DAQBuilderCommentNormalState.hh>
#include <Util/DAQBuilderCommentSlashState.hh>
#include <Util/DAQBuilderCommentStarState.hh>
#include <Util/DAQBuilderCommentSlashSlashState.hh>
namespace DAQBuilder
{
   CommentEraser::CommentEraser()
     :Object(),_source("")
    {
      _setType();
      _setParentClasses();
      installState( new CommentNormalState() );
      installState( new CommentSlashState() );
      installState( new CommentSlashSlashState() );
      installState( new CommentStarState() );
    }
    CommentEraser::~CommentEraser()

    {
      _finalize();
    }
    CommentEraser::CommentEraser( const CommentEraser& right )
      :Object(*((Object*)&right)),_source(right._source),_index(right._index)
       ,_status(right._status),_state(right._state)
    {
    }
    CommentEraser& CommentEraser::operator=( const CommentEraser& right )
    {
      *((Object*)this)= *((Object*)&right);
      _source         = right._source;
      _index          = right._index;
      _status         = right._status;
      _state          = right._state;
      return *this;
    }
    void CommentEraser::installState( CommentStateBase* state )
    {
     if(state!=NULL){
      SmartPointer aState;
      aState = state;
      _state.push_back(aState);
      }
    }
    DString       CommentEraser::result( const DString& source )
    {
      _source = source;
      if(_state.empty())
	return _source;
      _status = _state[CommentEraser::normalState];
      for( _index = _source.begin() ; _index != _source.end() ; _index++ )
	{
	  ((CommentStateBase*)_status.get())->process(*this);
	}
      return _source;
    }
}
