#ifndef  _DAQBuilderCommentEraser_HH
#define  _DAQBuilderCommentEraser_HH
#include <DAQBuilderObject.hh>
#include <Util/DAQBuilderSmartPointer.hh>
namespace DAQBuilder
{
  class CommentStateBase;
  class CommentNormalState;
  class CommentSlashState;
  class CommentSlashSlashState;
  class CommentStarState;
  class CommentEraser : public Object
  {
    friend class CommentStateBase;
    friend class CommentNormalState;
    friend class CommentSlashState;
    friend class CommentSlashSlashState;
    friend class CommentStarState;
  protected : 
    enum{normalState, SlashState, SlashSlashState, StarState , NumState };
    DString                   _source;    
    DString::iterator         _index;
    SmartPointer              _status;
    std::vector<SmartPointer> _state;
  protected:
    virtual void _finalize();
    virtual void _setType();
    virtual void _setParentClasses();
  protected:
    void installState( CommentStateBase* state );
  public   :
    CommentEraser();
    virtual ~CommentEraser();
    CommentEraser( const CommentEraser& right );
    CommentEraser& operator=( const CommentEraser& right );
  public :
    DString       result( const DString& _source );
  };
  inline void CommentEraser::_finalize()
  {;}
  inline void CommentEraser::_setType()
  {
    this -> _type = "CommentEraser";
  }
  inline void CommentEraser::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
}
#endif
