#include <Util/DAQBuilderMatcher.hh>
#include <Util/DAQBuilderPattern.hh>

namespace DAQBuilder
{
  void              Matcher::_finalize()
  {
    ;
  }
  Matcher::Matcher()
    :Object()
  {
    bzero( &_matcherRegister,sizeof(_matcherRegister));
    bzero( &_matcher,        sizeof(_matcher));
    _setType();
    _setParentClasses();
  }
  Matcher::Matcher( const Pattern& parentPattern , const DString& source )
    :Object(),_parentPattern(parentPattern),_source(source)
  {
    bzero( &_matcherRegister,sizeof(_matcherRegister));
    bzero( &_matcher,        sizeof(_matcher));
    _setType();
    _setParentClasses();
    //std::cout<< _parentPattern._preg.re_nsub << std::endl;
  }
  Matcher::Matcher( const Matcher& right )
    :Object(*((Object*)&right)),_parentPattern(right._parentPattern),_source(right._source)
  {
    bcopy( &right._matcherRegister,&_matcherRegister,sizeof(right._matcherRegister));
    bcopy( &right._matcher,        &_matcher,        sizeof(right._matcher));
  }
  
  Matcher::~Matcher()
  {
    _finalize();
  }
  Matcher&              Matcher::operator= ( const Matcher & right )
  {
    *((Object*)this) =     *((Object*)&right);
    _parentPattern   = right._parentPattern;
    _source          = right._source;
    bcopy( &right._matcherRegister,&_matcherRegister,sizeof(right._matcherRegister));
    bcopy( &right._matcher,        &_matcher,        sizeof(right._matcher));
    return *this;
  }
  
  DBool  Matcher::equals( const Object * o ) const 
  {
    if(!findParent(_type,o))
      return false;
    return equals( *((Matcher*)o));
  }
  DBool  Matcher::equals( const Matcher& o ) const 
  {
    DBool aBool = _parentPattern.equals(o._parentPattern);
    aBool      |= _source        == o._source;
    return aBool;
  }
  
  const DString     Matcher::toString() const 
  {
    DString aString = _parentPattern.toString();
    aString        += "Source : ";
    aString        += _source;
    aString        += "\n";
    return aString;
  }
  Pattern           Matcher::getPattern() const
  {
    return _parentPattern;
  }
  
  DUInt              Matcher::getGroupCount() const 
  {
    //return _matcherRegister.num_regs-1;
    return _matcherRegister.num_regs;
  }
  DString           Matcher::group( const DUInt& groupNumber  )
  {
    DInt aStart = start(groupNumber);
    DInt aEnd   = end(groupNumber)-1;
    if( aStart < 0 || aEnd < 0 )
      return DString("");
    return _source.substr( aStart , aEnd - aStart );
  }
  DInt              Matcher::start( const DUInt& groupNumber  )
  {
    if( getGroupCount() <= groupNumber )
      return -1;
    return _matcherRegister.start[groupNumber];
  }
  DInt              Matcher::end( const DUInt& groupNumber  )
  {
    if( getGroupCount() <= groupNumber )
      return -1;
    return _matcherRegister.end[groupNumber]+1;
  }
  
  DBool              Matcher::find( const DInt& position )
  {
    DInt aPos = -1;
    if( (aPos = re_search(&_parentPattern._preg,_source.c_str(),_source.size(),position,(position+_source.size())-1,&_matcherRegister ))>=0)
      return true;
    else
      return false;
  }
  DBool             Matcher::matches()
  {
    if( re_match(&_parentPattern._preg,_source.c_str(),_source.size(),0,&_matcherRegister) >= 0 )
      return true;
    else
      return false;
  }
  
  Matcher           Matcher::reset( const DString& source  )
  {
    return Matcher(_parentPattern,source);
  }
  
  DString           Matcher::replaceAll( const DString& replacement )
  {
    DString aResult   = _source;
    DInt    aEx       =0;
    DInt    aPosition =0; 
    while(find(aPosition))
      {
        DInt aStart = start(0)+aEx;
        DInt aEnd   = end(0)-1+aEx;
        DInt aSize  = aEnd   - aStart;
       if( aStart < 0 || aEnd < 0 || aSize < 1)
         break;
	DString aSub = aResult.substr( aStart , aSize );
	aResult.replace( aStart , aSize , replacement  , 0 , replacement.size());
        aEx += replacement.size() - aSub.size();
        aPosition = aEnd+1;
      }
    return aResult;
  }
  DString           Matcher::replaceFirst( const DString& replacement )
  {
    DString aResult   = _source;
    if(find())
      {
        DInt aStart = start(0);
        DInt aEnd   = end(0)-1;
        DInt aSize  = aEnd   - aStart;
       if( aStart >= 0 || aEnd >= 0 || aSize >= 1){
	DString aSub = aResult.substr( aStart , aSize );
	aResult.replace( aStart , aSize , replacement  , 0 , replacement.size());
       }
      }
    return aResult;
  }
}

