#ifndef __DAQBuilderMatcher_HH__
#define __DAQBuilderMatcher_HH__
#include <DAQBuilderObject.hh>
#include <Util/DAQBuilderPattern.hh>

namespace DAQBuilder
{
  class Matcher : public Object
  {
    friend class Pattern;
  protected:
    virtual  void              _finalize();
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  protected:
    Matcher();
    Matcher( const Pattern& _parentPattern , const DString& _source );
  public:
    Matcher( const Matcher& right);
    virtual ~Matcher();
    Matcher&              operator= ( const Matcher & right );
  public :
    virtual DBool  equals( const Object * o ) const ;
    virtual DBool  equals( const Matcher& o ) const ;
  protected:
    Pattern             _parentPattern;
    DString             _source;
    struct re_registers _matcherRegister;
    regmatch_t          _matcher;
  public :
    const DString     toString() const ;
    Pattern           getPattern() const;

    DUInt             getGroupCount() const ;
    DString           group( const DUInt& groupNumber = 0 );
    DInt              start( const DUInt& groupNumber = 0 );
    DInt              end( const DUInt& groupNumber = 0 );

    DBool             find( const DInt& position = 0 );
    DBool             matches();
  
    Matcher           reset( const DString& source = "" );
    
    DString           replaceAll( const DString& replacement );
    DString           replaceFirst( const DString& replacement );
  };
  inline void Matcher::_setType()
  {
     _type ="Matcher";
  }
  inline void Matcher::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
}
#endif
