#include <Util/DAQBuilderPattern.hh>
#include <Util/DAQBuilderMatcher.hh>
#include <System/IO/DAQBuilderByteArrayOutputStream.hh>
#include <System/IO/DAQBuilderPrimitiveDataOutputStream.hh>
#include <System/IO/DAQBuilderByteArrayInputStream.hh>
#include <System/IO/DAQBuilderPrimitiveDataInputStream.hh>

namespace DAQBuilder
{
  void              Pattern::_finalize()
  {;}
  
  Pattern::Pattern()
    :SerializableObject()
  {
    _setType();
    _setParentClasses();
    bzero(&_preg,sizeof(_preg));
   }

  Pattern::Pattern( const DString& pattern , const DULong & flags  )
      throw( PatternSyntaxException * )
    :SerializableObject(),_pattern(pattern),_flags(flags)
  {
    _setType();
    _setParentClasses();
    bzero(&_preg,sizeof(_preg));
    _preg.syntax = _flags;
    const DChar * aMessage = re_compile_pattern(_pattern.c_str(),_pattern.size(),&_preg);
    if( aMessage!=NULL){
      regfree(&_preg);
      PatternSyntaxException * e = new PatternSyntaxException("Patten Compile Error"); 
      e -> insert("Location","Pattern::Pattern( const DString& pattern , const DInt& flags)");
      e -> insert("Pattern",_pattern);
      e -> insert("Error",aMessage);
      throw e;
    }
  }
  
  Pattern::Pattern( const Pattern& right)
    :SerializableObject(*((SerializableObject*)&right)),_pattern(right._pattern),_flags(right._flags)
  {
    bcopy(&right._preg,&_preg,sizeof(right._preg));
  }
  Pattern::~Pattern()
  {
    _finalize();
  }
  Pattern&              Pattern::operator= ( const Pattern & right )
  {
    *((Object*)this) =  *((Object*)&right);
    _pattern         = right._pattern;
    _flags           = right._flags;
    bcopy(&right._preg,&_preg,sizeof(right._preg));
    return *this;
  }

  void                       Pattern::serialize(   DByte *& data , DULong& dataSize )
  {
    ByteArrayOutputStream     aBAO;   
    PrimitiveDataOutputStream aPDO(&aBAO);
    aPDO.writeString(_pattern);
    aPDO.writeULong(_flags);
    return aBAO.toByteArray(data,dataSize);
  }
  ByteArray                  Pattern::serialize()
  {
    ByteArrayOutputStream     aBAO;   
    PrimitiveDataOutputStream aPDO(&aBAO);
    aPDO.writeString(_pattern);
    aPDO.writeULong(_flags);
    return aBAO.toByteArray();
  }
  void                       Pattern::unSerialize( DByte * data, const DULong& dataSize )
  {    
    ByteArrayInputStream            aBAI(data,dataSize);   
    PrimitiveDataInputStream        aPDI(&aBAI);
    _pattern = aPDI.readString();
    _flags   = aPDI.readULong();
    try{
    operator =( Pattern(_pattern,_flags) );
    }catch(PatternSyntaxException * e ){
      std::cout<< e << std::endl;
      delete e;
    }
  }
  Cloneable *                Pattern::clone() const 
  {
     return new Pattern(*this);
  }
  
  DBool  Pattern::equals( const Object * o ) const 
  {
    if(!findParent(_type,o)){
      return false;
    }
    return equals(*((Pattern*)o));
  }
  DBool  Pattern::equals( const Pattern& o ) const 
  {
    DBool aBool  = _pattern == o._pattern;
    aBool       |= _flags   == o._flags;
    return aBool;
  }
  
  const DString    Pattern::toString() const
  {
    DString aString = "Pattern : ";
    aString        += _pattern;
    return aString;
  }
  Pattern    Pattern::compile( const DString& regex , const DULong& flags )
      throw( PatternSyntaxException * )
  {
    return Pattern( regex , flags );
  }

  const DULong&       Pattern::getFlags() const 
  {
    return _flags;
  }

  Matcher           Pattern::matcher( const DString& source )
  {
   /*Matcher aMatcher(*this,source);
   if(aMatcher.matches())
     return aMatcher;
   */
   return Matcher(*this,source);
  }
  /*
  DBool      Pattern::matches( const DString& regex , const DString& source )
  {
  }*/
  const  DString&   Pattern::getPerren() const
  {
     return _pattern;
  }
  /*  StringList        Pattern::split( const DString& source )
  {
  }*/
}
