#ifndef __DAQBuilderPattern_HH__
#define __DAQBuilderPattern_HH__
#include <DAQBuilderSerializableObject.hh>
#include <System/DAQBuilderSerializableObjectLoader.hh>
#include <Exception/DAQBuilderPatternSyntaxException.hh>

namespace DAQBuilder
{
  class Matcher;
  class Pattern : public SerializableObject
  {
    friend class Matcher;
  protected:
    virtual  void              _finalize();
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  protected:
    Pattern();
    Pattern( const DString& pattern , const DULong& flags  )
      throw( PatternSyntaxException * );
  public:
    Pattern( const Pattern& right );
    virtual ~Pattern();
    Pattern&              operator= ( const Pattern & right );
  public :
    virtual void                       serialize(   DByte *& ,       DULong&  );
    virtual ByteArray                  serialize();
    virtual void                       unSerialize( DByte *  , const DULong&  );
    virtual Cloneable *                clone() const ;
  public :
    virtual DBool  equals( const Object * o ) const ;
    virtual DBool  equals( const Pattern& o ) const ;
  protected:
    DString                    _pattern;
    DULong                     _flags;
    struct re_pattern_buffer   _preg;
  public :
    const  DString    toString() const;

    static Pattern    compile( const DString& _pattern , const DULong& _flags = RE_SYNTAX_POSIX_BASIC )
      throw( PatternSyntaxException * );
    const  DULong&      getFlags() const ;
 
    Matcher           matcher( const DString& source );
    //    static DBool      matches( const DString& regex , const DString& source );
    const  DString&   getPerren() const;
    //    StringList        split( const DString& source );
  };
  inline void Pattern::_setType()
  {
    this -> _type ="Pattern";
  }
  inline void Pattern::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Serializable");
    _parentClasses.insert("PubliclyCloneable");
    _parentClasses.insert("SerializableObject");
  }
}
#endif
