#include <Util/DAQBuilderPopupLogo.hh>
#include <System/DAQBuilderSystem.hh>

namespace DAQBuilder
{
  const DString PopupLogo::toString() const 
  {
    DString returnString ="XpmFile  : ";
    returnString += _xpmFile;
    return returnString;
  }
  void              PopupLogo::_setType()
  {
    _type ="PopupLogo";
  }
  void              PopupLogo::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Runnable");
    _parentClasses.insert("Thread");
  }
  
  PopupLogo::PopupLogo( const DString& xpmFile , const DInt& showTime)
    :Thread(),_xpmFile(xpmFile),
    _showTime(showTime),
     _logoDisplay(NULL),_logoWindow(0),_logoPixmap(0)
  {
    _setType();
    _setParentClasses();
  }
  PopupLogo::PopupLogo( const PopupLogo& right )
    :Thread(*((Thread*)&right)),_xpmFile(right._xpmFile),
     _showTime(right._showTime),
     _logoDisplay(right._logoDisplay),_logoWindow(right._logoWindow),_logoPixmap(right._logoPixmap)
  {

  }
  PopupLogo& PopupLogo::operator=( const PopupLogo& right )
  {
    *((Thread*)this)=    *((Thread*)&right);
    _xpmFile        = right._xpmFile;
    _showTime       = right._showTime;
    _logoDisplay    = right._logoDisplay;
    _logoWindow     = right._logoWindow;
    _logoPixmap     = right._logoPixmap;
    return *this;
  }

  PopupLogo::~PopupLogo()
  {
  //  _finalize();
  }
  
  void              PopupLogo::run()
  { 
     if ( _logoPixmap ) {
    return;
  }

  _logoDisplay = XOpenDisplay( NULL );
  if ( !_logoDisplay ) {
    return;
  }

  DInt screen = DefaultScreen(  _logoDisplay );
  DULong back = WhitePixel( _logoDisplay, screen );
  DULong fore = BlackPixel( _logoDisplay, screen );
  _logoWindow =    XCreateSimpleWindow( _logoDisplay, DefaultRootWindow( _logoDisplay ),
			 -100, -100, 50, 50, 0, fore, back );
  DInt depth = PlanesOfScreen( XDefaultScreenOfDisplay( _logoDisplay ) );
  if ( depth > 1 ) {
    XWindowAttributes win_attr;
    XGetWindowAttributes( _logoDisplay, _logoWindow, &win_attr );

    XpmAttributes attr;
    attr.valuemask = XpmVisual | XpmColormap | XpmDepth;
    attr.visual = win_attr.visual;
    attr.colormap = win_attr.colormap;
    attr.depth = win_attr.depth;
    attr.valuemask |= XpmColorKey;

    if ( depth > 4 ){
      attr.color_key = XPM_COLOR;
    }else if ( depth > 2 ){
      attr.color_key = XPM_GRAY4;
    }else if ( depth > 1 ){
      attr.color_key = XPM_GRAY;
    }else if ( depth == 1 ){
      attr.color_key = XPM_MONO;
    }else{
      attr.valuemask &= ~XpmColorKey;
    }

    DChar tmpFname[256];
    strcpy(tmpFname,_xpmFile.c_str());
    XpmReadFileToPixmap( _logoDisplay, _logoWindow,
			 tmpFname,    &_logoPixmap,
			 (Pixmap *)0, &attr );
    XpmFreeAttributes( &attr );
  }

  Window root;
  DInt x;
  DInt y;
  DUInt w;
  DUInt h;
  DUInt bw;
  DUInt dep;

  XGetGeometry( _logoDisplay, _logoPixmap, &root, &x, &y, &w, &h, &bw, &dep );
  Screen* xscreen = XDefaultScreenOfDisplay( _logoDisplay );
  x = ( WidthOfScreen( xscreen ) - w ) / 2;
  y = ( HeightOfScreen( xscreen ) - h ) / 2;
  XMoveResizeWindow( _logoDisplay, _logoWindow, x, y, w, h );
  XSync( _logoDisplay, False );

  DULong valmask;
  XSetWindowAttributes xswa;
  valmask = CWBackPixmap | CWOverrideRedirect;
  xswa.background_pixmap = _logoPixmap;
  xswa.override_redirect = true;
  XChangeWindowAttributes( _logoDisplay, _logoWindow, valmask, &xswa );

  XMapRaised( _logoDisplay, _logoWindow );
  XSync( _logoDisplay, False );

  sleep(_showTime);
  if ( _logoWindow ) 
    {
      XUnmapWindow( _logoDisplay, _logoWindow );
      XDestroyWindow( _logoDisplay, _logoWindow );
      _logoWindow = 0;
    }
  if ( _logoPixmap ) 
    {
      XFreePixmap( _logoDisplay, _logoPixmap );
      _logoPixmap = 0;
    }
  if ( _logoDisplay ) 
    {
      XSync( _logoDisplay, False );
      XCloseDisplay( _logoDisplay );
      _logoDisplay = 0;
    }
  return;
  }
  
  void  PopupLogo::show()
  {
    start();
    /*if(!isDeamon())
     setDeamon();*/
  }
}
